/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.core.preferences;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.core.preferences.IOpenShiftCoreConstants;
import org.jboss.tools.openshift.internal.common.core.preferences.StringPreferenceValue;
import org.jboss.tools.openshift.internal.common.core.preferences.StringsPreferenceValue;

public class OpenShiftCorePreferences
implements IOpenShiftCoreConstants {
    public static final OpenShiftCorePreferences INSTANCE = new OpenShiftCorePreferences();
    private static final String CONNECTIONS = "org.jboss.tools.openshift.core.connection.CONNECTION_NAMES";
    private static final String CONNECTION_AUTH_PREFIX = "org.jboss.tools.openshift.core.connection.auth";
    private final StringsPreferenceValue connectionsPreferenceValue = new StringsPreferenceValue('|', "org.jboss.tools.openshift.core.connection.CONNECTION_NAMES", "org.jboss.tools.openshift.core");
    private final StringPreferenceValue ocBinaryLocation = new StringPreferenceValue("openshift.cli.location", "org.jboss.tools.openshift.core");

    private OpenShiftCorePreferences() {
    }

    public String[] loadConnections() {
        return this.connectionsPreferenceValue.get();
    }

    public void saveConnections(String[] connections) {
        this.connectionsPreferenceValue.set(connections);
    }

    public void saveAuthScheme(String connectionURL, String scheme) {
        this.createPreferenceValue(connectionURL).set(scheme);
    }

    public void removeAuthScheme(String connectionURL) {
        this.createPreferenceValue(connectionURL).remove();
    }

    public String loadScheme(String connectionURL) {
        return this.createPreferenceValue(connectionURL).get();
    }

    private StringPreferenceValue createPreferenceValue(String connectionURL) {
        return new StringPreferenceValue(NLS.bind((String)"{0}.{1}", (Object)CONNECTION_AUTH_PREFIX, (Object)connectionURL), "org.jboss.tools.openshift.core");
    }

    public String getOCBinaryLocation() {
        return this.ocBinaryLocation.get();
    }

    public void saveOCBinaryLocation(String location) {
        this.ocBinaryLocation.set(location);
    }
}

