/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.importer;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.core.util.ConvertUtility;
import org.eclipse.wst.jsdt.ui.importer.Activator;

public class JSDTProjectNature
implements ProjectConfigurator {
    private static final String FILE_EXTENSION = ".js";

    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        JavaScriptResourceExistsFinder javaResourceFinder = new JavaScriptResourceExistsFinder(ignoredDirectories);
        try {
            project.accept((IResourceVisitor)javaResourceFinder);
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.javascript", ex.getMessage(), (Throwable)ex));
            return false;
        }
        return javaResourceFinder.hasJavaFile();
    }

    public IWizard getConfigurationWizard() {
        return null;
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            new ConvertUtility(project).configure(monitor);
            IJavaScriptProject cfr_ignored_0 = (IJavaScriptProject)project.getNature("org.eclipse.wst.jsdt.core.jsNature");
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.playground.easymport.javascript", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return false;
    }

    public Set<IFolder> getDirectoriesToIgnore(IProject project, IProgressMonitor monitor) {
        return null;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return Collections.EMPTY_SET;
    }

    private static final class JavaScriptResourceExistsFinder
    implements IResourceVisitor {
        private boolean hasJSFile;
        private Set<IPath> ignoredDirectories;

        public JavaScriptResourceExistsFinder(Set<IPath> ignoredDirectories) {
            this.ignoredDirectories = ignoredDirectories;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.ignoredDirectories != null) {
                for (IPath ignoredDirectory : this.ignoredDirectories) {
                    if (!ignoredDirectory.isPrefixOf(resource.getLocation())) continue;
                    return false;
                }
            }
            this.hasJSFile = this.hasJSFile || resource.getType() == 1 && resource.getName().endsWith(JSDTProjectNature.FILE_EXTENSION);
            return !this.hasJSFile;
        }

        public boolean hasJavaFile() {
            return this.hasJSFile;
        }
    }

    private static final class JavaScriptResourceFinder
    implements IResourceVisitor {
        private Set<IContainer> mostLikelySourceFolders = new HashSet<IContainer>();
        private Set<IPath> ignoredDirectories;

        public JavaScriptResourceFinder(Set<IPath> ignoredDirectories) {
            this.ignoredDirectories = ignoredDirectories;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.ignoredDirectories != null) {
                for (IPath ignoredDirectory : this.ignoredDirectories) {
                    if (!ignoredDirectory.isPrefixOf(resource.getLocation())) continue;
                    return false;
                }
            }
            if (resource.getType() != 1 || !resource.getName().endsWith(JSDTProjectNature.FILE_EXTENSION)) {
                return true;
            }
            this.mostLikelySourceFolders.add(resource.getParent());
            return false;
        }

        public Set<IContainer> getSourceFolders() {
            HashSet<IContainer> res = new HashSet<IContainer>();
            res.addAll(this.mostLikelySourceFolders);
            for (IContainer item : this.mostLikelySourceFolders) {
                boolean alreadyContainsAParent = false;
                HashSet<IContainer> childrenOfItem = new HashSet<IContainer>();
                for (IContainer other : res) {
                    if (item.getFullPath().isPrefixOf(other.getFullPath())) {
                        childrenOfItem.add(other);
                        continue;
                    }
                    if (!other.getFullPath().isPrefixOf(item.getFullPath())) continue;
                    alreadyContainsAParent = true;
                }
                res.removeAll(childrenOfItem);
                if (alreadyContainsAParent) continue;
                res.add(item);
            }
            return res;
        }
    }
}

