/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

public final class PlatformUtil {
    private static final String MAC = "mac";
    private static final String DARWIN = "darwin";
    private static final String WIN = "win";
    private static final String LINUX = "nux";
    private static OS detectedOs;

    private PlatformUtil() {
    }

    public static boolean isWindows() {
        return OS.WINDOWS.equals((Object)PlatformUtil.getOs());
    }

    public static boolean isMacOS() {
        return OS.MACOS.equals((Object)PlatformUtil.getOs());
    }

    public static boolean isLinux() {
        return OS.LINUX.equals((Object)PlatformUtil.getOs());
    }

    public static OS getOs() {
        if (detectedOs == null) {
            String currentOs = System.getProperty("os.name", "generic").toLowerCase();
            detectedOs = currentOs.indexOf(MAC) >= 0 || currentOs.indexOf(DARWIN) >= 0 ? OS.MACOS : (currentOs.indexOf(WIN) >= 0 ? OS.WINDOWS : (currentOs.indexOf(LINUX) >= 0 ? OS.LINUX : OS.OTHER));
        }
        return detectedOs;
    }

    public static enum OS {
        WINDOWS,
        MACOS,
        LINUX,
        OTHER;

    }
}

