/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.io.Serializable;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluggableTextTableLabelProvider<E>
extends BaseLabelProvider
implements ITableLabelProvider {
    private volatile TextTransformer<E> textTransformer;

    public PluggableTextTableLabelProvider() {
        this(DefaultTextTransformer.instance());
    }

    public PluggableTextTableLabelProvider(TextTransformer<E> textTransformer) {
        if (textTransformer == null) {
            throw new NullPointerException();
        }
        this.textTransformer = textTransformer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.textTransformer.transform(element, columnIndex);
    }

    public void setTextTransformer(TextTransformer<E> textTransformer) {
        if (textTransformer == null) {
            throw new NullPointerException();
        }
        this.textTransformer = textTransformer;
    }

    public String toString() {
        return ObjectTools.toString((Object)((Object)this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultTextTransformer<E>
    implements TextTransformer<E>,
    Serializable {
        public static final TextTransformer<?> INSTANCE = new DefaultTextTransformer();
        private static final long serialVersionUID = 1L;

        public static <R> TextTransformer<R> instance() {
            return INSTANCE;
        }

        private DefaultTextTransformer() {
        }

        @Override
        public String transform(E element, int columnIndex) {
            return element == null ? null : element.toString();
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TextTransformer<E>
    extends Transformer<E, String> {
        @Override
        public String transform(E var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Transformer<T1, T2> {
        public T2 transform(T1 var1, int var2);
    }
}

