/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.OpenShiftException;
import com.openshift.client.SSHKeyPair;
import com.openshift.client.SSHKeyType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AbstractSSHKeyWizardPageModel;

public class NewSSHKeyWizardPageModel
extends AbstractSSHKeyWizardPageModel {
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_SSH2_HOME = "SSH2Home";
    public static final String PROPERTY_PRIVATEKEY_FILENAME = "privateKeyName";
    public static final String PROPERTY_PRIVATEKEY_PASSPHRASE = "privateKeyPathphrase";
    public static final String PROPERTY_PRIVATEKEY_CONFIRM_PASSPHRASE = "privateKeyPassphraseConfirm";
    public static final String PROPERTY_PUBLICKEY_FILENAME = "publicKeyName";
    private static final String PUBLICKEY_SUFFIX = ".pub";
    private SSHKeyType type = SSHKeyType.SSH_RSA;
    private String ssh2Home = SSHUtils.getSSH2Home();
    private String privateKeyName;
    private String privateKeyPathphrase;
    private String privateKeyPathphraseConfirm;
    private String publicKeyName;
    private IOpenShiftSSHKey key;

    public NewSSHKeyWizardPageModel(ExpressConnection user) {
        super(user);
    }

    public SSHKeyType getType() {
        return this.type;
    }

    public void setType(SSHKeyType type) {
        this.type = type;
        this.firePropertyChange(PROPERTY_TYPE, this.type, this.type);
    }

    public String getPrivateKeyPathphrase() {
        return this.privateKeyPathphrase;
    }

    public String getPrivateKeyPassphraseConfirm() {
        return this.privateKeyPathphraseConfirm;
    }

    public void setPrivateKeyPassphraseConfirm(String confirm) {
        this.privateKeyPathphraseConfirm = confirm;
        this.firePropertyChange(PROPERTY_PRIVATEKEY_CONFIRM_PASSPHRASE, this.privateKeyPathphraseConfirm, this.privateKeyPathphraseConfirm);
    }

    public void setPrivateKeyPathphrase(String privateKeyPathphrase) {
        this.privateKeyPathphrase = privateKeyPathphrase;
        this.firePropertyChange(PROPERTY_PRIVATEKEY_PASSPHRASE, this.privateKeyPathphrase, this.privateKeyPathphrase);
    }

    public String getPrivateKeyName() {
        return this.privateKeyName;
    }

    public void setPrivateKeyName(String privateKeyName) {
        String oldPrivateKeyName = this.getPrivateKeyName();
        this.privateKeyName = privateKeyName;
        this.firePropertyChange(PROPERTY_PRIVATEKEY_FILENAME, this.privateKeyName, this.privateKeyName);
        this.updatePublicKeyNameFromPrivateKey(oldPrivateKeyName, privateKeyName);
    }

    private void updatePublicKeyNameFromPrivateKey(String oldPrivateKeyName, String privateKeyName) {
        if (StringUtils.isEmpty((String)this.publicKeyName)) {
            this.setPublicKeyName(String.valueOf(privateKeyName) + PUBLICKEY_SUFFIX);
        } else {
            String publicKeyNameNoSuffix = StringUtils.getWithoutSuffix((String)this.publicKeyName, (String)PUBLICKEY_SUFFIX);
            if (oldPrivateKeyName.startsWith(publicKeyNameNoSuffix)) {
                this.setPublicKeyName(String.valueOf(privateKeyName) + PUBLICKEY_SUFFIX);
            }
        }
    }

    public String getPublicKeyName() {
        return this.publicKeyName;
    }

    public void setPublicKeyName(String publicKeyName) {
        this.publicKeyName = publicKeyName;
        this.firePropertyChange(PROPERTY_PUBLICKEY_FILENAME, this.publicKeyName, this.publicKeyName);
    }

    public String getSSH2Home() {
        return this.ssh2Home;
    }

    public void setSSH2Home(String ssh2Home) {
        this.ssh2Home = ssh2Home;
        this.firePropertyChange(PROPERTY_SSH2_HOME, this.ssh2Home, this.ssh2Home);
    }

    @Override
    public File getPublicKey() {
        return new File(this.ssh2Home, this.publicKeyName);
    }

    @Override
    public IOpenShiftSSHKey addSSHKey() throws FileNotFoundException, OpenShiftException, IOException {
        SSHKeyPair keyPair = this.createSSHKey();
        SSHUtils.addToPrivateKeysPreferences(new File(keyPair.getPrivateKeyPath()));
        this.key = this.getConnection().putSSHKey(this.getName(), (ISSHPublicKey)keyPair);
        return this.key;
    }

    private SSHKeyPair createSSHKey() {
        this.ensureSSHHomeExists(this.ssh2Home);
        File privateKey = new File(this.ssh2Home, this.privateKeyName);
        File publicKey = new File(this.ssh2Home, this.publicKeyName);
        SSHKeyPair keyPair = SSHKeyPair.create((String)this.privateKeyPathphrase, (String)privateKey.getAbsolutePath(), (String)publicKey.getAbsolutePath());
        SSHUtils.setPrivateKeyPermissions(privateKey);
        return keyPair;
    }

    private void ensureSSHHomeExists(String ssh2Home) throws OpenShiftException {
        File ssh2HomeFile = new File(ssh2Home);
        if (FileUtils.canRead((File)ssh2HomeFile)) {
            if (!FileUtils.isDirectory((File)ssh2HomeFile)) {
                throw new OpenShiftException(String.valueOf(ssh2Home) + " is a file instead of a directory. This prevents creation and usage of ssh keys", new Object[0]);
            }
            return;
        }
        try {
            if (!ssh2HomeFile.mkdirs()) {
                throw new OpenShiftException("Could not create ssh2 home directory at {0}", new Object[]{ssh2Home});
            }
        }
        catch (SecurityException e) {
            throw new OpenShiftException((Throwable)e, "Could not create ssh2 home directory at {0}", new Object[]{ssh2Home});
        }
    }

    @Override
    public IOpenShiftSSHKey getSSHKey() {
        return this.key;
    }
}

