/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.ssh;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.SSHKeyType;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.SSHUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.AddSSHKeyJob;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.NewSSHKeyWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.ssh.databinding.SSHPublicKeyNameValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.DirectoryValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.FileNameValidator;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class NewSSHKeyWizardPage
extends AbstractOpenShiftWizardPage {
    private NewSSHKeyWizardPageModel pageModel;

    public NewSSHKeyWizardPage(ExpressConnection user, IWizard wizard) {
        super("Add new SSH key", "Add a new SSH key to your OpenShift user " + user.getUsername(), "NewSSHKeysPage", wizard);
        this.pageModel = new NewSSHKeyWizardPageModel(user);
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group newSSHKeyGroup = new Group(parent, 0);
        newSSHKeyGroup.setText("New SSH Key");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)newSSHKeyGroup);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(6, 6).applyTo((Composite)newSSHKeyGroup);
        Label nameLabel = new Label((Composite)newSSHKeyGroup, 0);
        nameLabel.setText("Name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        Text nameText = new Text((Composite)newSSHKeyGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)nameText);
        Binding nameBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)nameText)).validatingAfterConvert((IValidator)new SSHPublicKeyNameValidator(this.pageModel))).to(BeanProperties.value((String)"name").observe((Object)this.pageModel)).notUpdatingParticipant()).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)nameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label typeLabel = new Label((Composite)newSSHKeyGroup, 0);
        typeLabel.setText("Key Type:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)typeLabel);
        ComboViewer typeCombo = new ComboViewer((Composite)newSSHKeyGroup, 8);
        typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        typeCombo.setInput((Object)SSHKeyType.values());
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo(typeCombo.getControl());
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)typeCombo)).to(BeanProperties.value((String)"type").observe((Object)this.pageModel)).in(dbc);
        Label fillerLabel = new Label((Composite)newSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)fillerLabel);
        Label ssh2HomeLabel = new Label((Composite)newSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)ssh2HomeLabel);
        ssh2HomeLabel.setText("SSH2 Home:");
        Text ssh2HomeText = new Text((Composite)newSSHKeyGroup, 2048);
        ssh2HomeText.setEditable(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)ssh2HomeText);
        Binding ssh2HomeBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)ssh2HomeText)).validatingAfterConvert((IValidator)new DirectoryValidator("ssh2 home directory"))).to(BeanProperties.value((String)"SSH2Home").observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)ssh2HomeBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Button ssh2HomeBrowseButton = new Button((Composite)newSSHKeyGroup, 8);
        ssh2HomeBrowseButton.setText("Browse...");
        ssh2HomeBrowseButton.addSelectionListener(this.onBrowse(ssh2HomeText));
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)ssh2HomeBrowseButton);
        Button defaultSSH2HomeHomeButton = new Button((Composite)newSSHKeyGroup, 32);
        defaultSSH2HomeHomeButton.setText("Default");
        defaultSSH2HomeHomeButton.addSelectionListener(this.onDefault(ssh2HomeText, ssh2HomeBrowseButton));
        defaultSSH2HomeHomeButton.setSelection(true);
        this.updateSSH2HomeWidgets(true, ssh2HomeText, ssh2HomeBrowseButton);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)ssh2HomeBrowseButton);
        Label privateKeyLabel = new Label((Composite)newSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)privateKeyLabel);
        privateKeyLabel.setText("Private Key File Name:");
        Text privateKeyText = new Text((Composite)newSSHKeyGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)privateKeyText);
        Binding privateKeyBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)privateKeyText)).validatingAfterConvert((IValidator)new FileNameValidator("Private Key File Name"))).to(BeanProperties.value((String)"privateKeyName").observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)privateKeyBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label passphraseLabel = new Label((Composite)newSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)passphraseLabel);
        passphraseLabel.setText("Private Key Passphrase:");
        Text passphraseText = new Text((Composite)newSSHKeyGroup, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)passphraseText);
        ISWTObservableValue passphraseObservable = WidgetProperties.text((int)24).observe((Widget)passphraseText);
        ValueBindingBuilder.bind((IObservableValue)passphraseObservable).to(BeanProperties.value((String)"privateKeyPathphrase").observe((Object)this.pageModel)).in(dbc);
        Label passphraseConfirmLabel = new Label((Composite)newSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)passphraseLabel);
        passphraseConfirmLabel.setText("Confirm Private Key Passphrase:");
        Text passphraseConfirmText = new Text((Composite)newSSHKeyGroup, 0x400800);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)passphraseConfirmText);
        ISWTObservableValue passphraseConfirmObservable = WidgetProperties.text((int)24).observe((Widget)passphraseConfirmText);
        ValueBindingBuilder.bind((IObservableValue)passphraseConfirmObservable).to(BeanProperties.value((String)"privateKeyPassphraseConfirm").observe((Object)this.pageModel)).in(dbc);
        PassPhraseConfirmValidator passPhraseConfrimValidator = new PassPhraseConfirmValidator((IObservableValue)passphraseObservable, (IObservableValue)passphraseConfirmObservable);
        dbc.addValidationStatusProvider((ValidationStatusProvider)passPhraseConfrimValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)passPhraseConfrimValidator, (int)16512);
        Label publicKeyLabel = new Label((Composite)newSSHKeyGroup, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)publicKeyLabel);
        publicKeyLabel.setText("Public Key File Name:");
        Text publicKeyText = new Text((Composite)newSSHKeyGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)publicKeyText);
        Binding publicKeyBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)publicKeyText)).validatingAfterConvert((IValidator)new FileNameValidator("Public Key File Name"))).to(BeanProperties.value((String)"publicKeyName").observe((Object)this.pageModel)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)publicKeyBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Link sshPrefsLink = new Link(parent, 0);
        sshPrefsLink.setText("The private key of your new SSH key pair will get added to the \n<a>SSH2 Preferences</a>");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sshPrefsLink);
        sshPrefsLink.addSelectionListener((SelectionListener)this.onSshPrefs());
    }

    private SelectionListener onBrowse(final Text ssh2HomeText) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(NewSSHKeyWizardPage.this.getShell(), 4096);
                dialog.setFilterPath(this.getFilterPath(ssh2HomeText.getText()));
                String ssh2HomePath = null;
                ssh2HomePath = dialog.open();
                if (ssh2HomePath != null) {
                    NewSSHKeyWizardPage.this.pageModel.setSSH2Home(ssh2HomePath);
                }
            }

            private String getFilterPath(String currentFilterPath) {
                if (StringUtils.isEmpty((String)currentFilterPath)) {
                    return currentFilterPath;
                }
                return SSHUtils.getSSH2Home();
            }
        };
    }

    private SelectionListener onDefault(final Text ssh2HomeText, final Button ssh2HomeBrowseButton) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSSHKeyWizardPage.this.updateSSH2HomeWidgets(((Button)e.widget).getSelection(), ssh2HomeText, ssh2HomeBrowseButton);
            }
        };
    }

    private void updateSSH2HomeWidgets(boolean isDefault, Text ssh2HomeText, Button ssh2HomeBrowseButton) {
        ssh2HomeText.setEnabled(!isDefault);
        ssh2HomeBrowseButton.setEnabled(!isDefault);
        if (isDefault) {
            ssh2HomeText.setText(SSHUtils.getSSH2Home());
        }
    }

    public IStatus addConfiguredSSHKey() {
        try {
            return WizardUtils.runInWizard((Job)new AddSSHKeyJob(this.pageModel), (IWizardContainer)this.getContainer());
        }
        catch (Exception exception) {
            return ExpressUIActivator.createErrorStatus("Could not add ssh key " + this.pageModel.getName() + ".");
        }
    }

    private SelectionAdapter onSshPrefs() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SSHUtils.openPreferencesPage(NewSSHKeyWizardPage.this.getShell());
            }
        };
    }

    public IOpenShiftSSHKey getSSHKey() {
        return this.pageModel.getSSHKey();
    }

    public class PassPhraseConfirmValidator
    extends MultiValidator {
        private IObservableValue passphrase;
        private IObservableValue passphraseConfirm;

        public PassPhraseConfirmValidator(IObservableValue passphrase, IObservableValue passphraseConfirm) {
            this.passphrase = passphrase;
            this.passphraseConfirm = passphraseConfirm;
        }

        protected IStatus validate() {
            boolean bothEmpty;
            Object o1 = this.passphrase.getValue();
            Object o2 = this.passphraseConfirm.getValue();
            boolean bl = bothEmpty = !(o1 != null && !"".equals(o1) || o2 != null && !"".equals(o2));
            if (!bothEmpty && !(o1 == null ? o2 : o1).equals(o1 == null ? o1 : o2)) {
                return ValidationStatus.error((String)"Please ensure the two passphrases match.");
            }
            return ValidationStatus.ok();
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.passphraseConfirm);
            return targets;
        }
    }
}

