/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import com.openshift.client.IDomain;
import java.util.Map;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.AbstractEnvironmentVariablesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableItem;

public class NewEnvironmentVariablesWizardModel
extends AbstractEnvironmentVariablesWizardModel {
    private Map<String, String> environmentVariables;
    private IDomain domain;

    public NewEnvironmentVariablesWizardModel(Map<String, String> environmentVariables, IDomain domain) {
        this.environmentVariables = environmentVariables;
        this.domain = domain;
    }

    @Override
    public void refreshEnvironmentVariables() {
        this.loadEnvironmentVariables();
    }

    @Override
    public void loadEnvironmentVariables() {
        this.clear();
        if (this.environmentVariables == null || this.environmentVariables.isEmpty()) {
            return;
        }
        this.add(this.environmentVariables);
    }

    private void add(Map<String, String> environmentVariables) {
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            this.add(new EnvironmentVariableItem(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public boolean isSupported() {
        return this.domain != null && this.domain.canCreateApplicationWithEnvironmentVariables();
    }

    @Override
    public String getHost() {
        if (this.domain == null || this.domain.getUser() == null) {
            return null;
        }
        return this.domain.getUser().getServer();
    }
}

