/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableWizardModel;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredStringValidator;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class EnvironmentVariableWizardPage
extends AbstractOpenShiftWizardPage {
    private EnvironmentVariableWizardModel model;

    public EnvironmentVariableWizardPage(EnvironmentVariableWizardModel model, IWizard wizard) {
        super(model.isEditing() ? "Edit an existing environment variable" : "Add a new environment variable", "Please choose a name and a value for environment variable", "", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group addApplicationEnvironmentVariableGroup = new Group(parent, 0);
        addApplicationEnvironmentVariableGroup.setText("Enviroment Variable");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)addApplicationEnvironmentVariableGroup);
        GridLayoutFactory.fillDefaults().numColumns(4).margins(6, 6).applyTo((Composite)addApplicationEnvironmentVariableGroup);
        Label nameLabel = new Label((Composite)addApplicationEnvironmentVariableGroup, 0);
        nameLabel.setText("Name:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)nameLabel);
        Text nameText = new Text((Composite)addApplicationEnvironmentVariableGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)nameText);
        Binding nameBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)nameText)).validatingAfterConvert((IValidator)new RequiredStringValidator("Name"){

            public IStatus validateString(String value) {
                if (EnvironmentVariableWizardPage.this.model.isExistingName(value)) {
                    return ValidationStatus.error((String)NLS.bind((String)"There's already an environment variable with the name {0}", (Object)value));
                }
                if (!StringUtils.startsWithLetterOrUnderscore((String)value) || !StringUtils.isAlphaNumericOrUnderscore((String)value)) {
                    return ValidationStatus.error((String)"Name can only contain letters, digits and underscore and can't begin with a digit.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"name").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)nameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label valueLabel = new Label((Composite)addApplicationEnvironmentVariableGroup, 0);
        valueLabel.setText("Value:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)valueLabel);
        Text valueText = new Text((Composite)addApplicationEnvironmentVariableGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)valueText);
        Binding valeuBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)valueText)).validatingAfterConvert((IValidator)new RequiredStringValidator("Value"))).to(BeanProperties.value((String)"value").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)valeuBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
    }
}

