/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.environment;

import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.AbstractEnvironmentVariablesWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.environment.EnvironmentVariableItem;

public class EnvironmentVariableWizardModel
extends ObservableUIPojo {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private String name;
    private String value;
    private EnvironmentVariableItem variable;
    private AbstractEnvironmentVariablesWizardModel allVariablesModel;

    public EnvironmentVariableWizardModel(AbstractEnvironmentVariablesWizardModel variablesModel) {
        this(new EnvironmentVariableItem(), variablesModel);
    }

    public EnvironmentVariableWizardModel(EnvironmentVariableItem variable, AbstractEnvironmentVariablesWizardModel variablesModel) {
        this.variable = variable;
        this.name = variable.getName();
        this.value = variable.getValue();
        this.allVariablesModel = variablesModel;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, this.name, this.name);
    }

    public String getName() {
        return this.variable.getName();
    }

    public void setValue(String value) {
        this.value = value;
        this.firePropertyChange(PROPERTY_VALUE, this.value, this.value);
    }

    public String getValue() {
        return this.value;
    }

    public EnvironmentVariableItem getVariable() {
        return this.variable;
    }

    public boolean isExistingName(String name) {
        EnvironmentVariableItem variable = this.allVariablesModel.getVariable(name);
        return variable != null && !variable.equals(this.variable);
    }

    public boolean isEditing() {
        return this.allVariablesModel.contains(this.variable);
    }

    public void updateVariable() {
        this.variable.setName(this.name);
        this.variable.setValue(this.value);
        if (!this.isEditing()) {
            this.allVariablesModel.add(this.variable);
        }
    }
}

