/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IStandaloneCartridge;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.cartridges.EmbedCartridgeStrategy;
import org.jboss.tools.openshift.express.internal.ui.wizard.embed.EmbeddedCartridgesWizardModel;

public class EmbeddedCartridgesWizardPageModel
extends ObservableUIPojo
implements EmbedCartridgeStrategy.IApplicationProperties {
    public static final String PROPERTY_EMBEDDABLE_CARTRIDGES = "embeddableCartridges";
    public static final String PROPERTY_SELECTED_CARTRIDGE = "selectedCartridge";
    public static final String PROPERTY_CHECKED_CARTRIDGES = "checkedCartridges";
    private EmbeddedCartridgesWizardModel applicationCartridges;
    private List<ICartridge> embeddableCartridges = new ArrayList<ICartridge>();
    private ICartridge selectedCartridge;

    public EmbeddedCartridgesWizardPageModel(EmbeddedCartridgesWizardModel applicationCartridges) {
        this.applicationCartridges = applicationCartridges;
    }

    public void loadOpenShiftResources() throws OpenShiftException {
        this.loadEmbeddableCartridges();
    }

    private void loadEmbeddableCartridges() throws OpenShiftException {
        List<ICartridge> cartridges = this.applicationCartridges.getEmbeddableCartridges();
        this.setEmbeddableCartridges(cartridges);
        this.setCheckedCartridges(this.applicationCartridges.getEmbeddedCartridges());
    }

    public void setEmbeddableCartridges(List<ICartridge> cartridges) {
        this.embeddableCartridges = cartridges;
        this.firePropertyChange(PROPERTY_EMBEDDABLE_CARTRIDGES, this.embeddableCartridges, this.embeddableCartridges);
    }

    public List<ICartridge> getEmbeddableCartridges() {
        return this.embeddableCartridges;
    }

    public Set<ICartridge> getCheckedCartridges() {
        return this.applicationCartridges.getCheckedEmbeddableCartridges();
    }

    public void setCheckedCartridges(Set<ICartridge> cartridges) throws OpenShiftException {
        this.firePropertyChange(PROPERTY_CHECKED_CARTRIDGES, null, this.applicationCartridges.setCheckedEmbeddableCartridges(cartridges));
    }

    public void uncheckAll() throws OpenShiftException {
        this.setCheckedCartridges(new HashSet<ICartridge>());
    }

    public void setSelectedCartridge(ICartridge cartridge) {
        this.selectedCartridge = cartridge;
        this.firePropertyChange(PROPERTY_SELECTED_CARTRIDGE, this.selectedCartridge, this.selectedCartridge);
    }

    public ICartridge getSelectedCartridge() {
        return this.selectedCartridge;
    }

    public boolean isEmbedded(ICartridge cartridge) throws OpenShiftException {
        return this.applicationCartridges.isEmbedded(cartridge);
    }

    public boolean hasApplication(IStandaloneCartridge cartridge) throws OpenShiftException {
        IDomain domain = this.getDomain();
        if (domain == null) {
            return false;
        }
        return domain.hasApplicationByCartridge(cartridge);
    }

    public void checkEmbeddedCartridge(ICartridge cartridge) throws OpenShiftException {
        this.getCheckedCartridges().add(cartridge);
        this.firePropertyChange(PROPERTY_CHECKED_CARTRIDGES, null, this.getCheckedCartridges());
    }

    public void uncheckEmbeddedCartridge(ICartridge cartridge) throws OpenShiftException {
        this.getCheckedCartridges().remove(cartridge);
        this.firePropertyChange(PROPERTY_CHECKED_CARTRIDGES, null, this.getCheckedCartridges());
    }

    public Set<ICartridge> refreshSelectedEmbeddedCartridges() throws OpenShiftException {
        this.applicationCartridges.refresh();
        this.setCheckedCartridges(this.applicationCartridges.getEmbeddedCartridges());
        return this.getCheckedCartridges();
    }

    public IDomain getDomain() throws OpenShiftException {
        return this.applicationCartridges.getDomain();
    }

    public ApplicationScale getApplicationScale() {
        return this.applicationCartridges.getApplicationScale();
    }

    public ICartridge getStandaloneCartridge() {
        return this.applicationCartridges.getStandaloneCartridge();
    }

    public String getApplicationName() {
        return this.applicationCartridges.getApplicationName();
    }
}

