/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.embed;

import com.openshift.client.cartridge.ICartridge;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.express.internal.core.cartridges.CodeAnythingCartridge;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.DataBindingUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.DisposeUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;

public class CartridgeDetailViews
extends AbstractStackedDetailViews {
    private IObservableValue canModifyCartridges;
    private final AbstractStackedDetailViews.IDetailView cartridgeView = new CartridgeDetailsView();
    private final AbstractStackedDetailViews.IDetailView downloadableCartridgeView = new DownloadableCartridgeView();
    private final AbstractStackedDetailViews.IDetailView codeAnythingCartridgeView = new CodeAnythingDetailsView();

    public CartridgeDetailViews(IObservableValue detailViewModel, IObservableValue canModifyCartridges, Composite parent, DataBindingContext dbc) {
        super(detailViewModel, null, parent, dbc);
        this.canModifyCartridges = canModifyCartridges;
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.codeAnythingCartridgeView, this.downloadableCartridgeView, this.cartridgeView};
    }

    private class CartridgeDetailsView
    extends AbstractStackedDetailViews.EmptyView {
        private StyledText nameLabel;
        private StyledText description;

        private CartridgeDetailsView() {
            super((AbstractStackedDetailViews)CartridgeDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(super.createControls(parent, context, dbc));
            GridLayoutFactory.fillDefaults().margins(10, 10).spacing(10, 10).applyTo(container);
            this.nameLabel = new StyledText(container, 8);
            StyledTextUtils.setTransparent((StyledText)this.nameLabel);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.nameLabel);
            this.description = new StyledText(container, 586);
            this.description.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.description);
            GridDataFactory.fillDefaults().align(16384, 4).grab(true, true).applyTo((Control)this.description);
            return container;
        }

        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            Object value = selectedCartridgeObservable.getValue();
            if (!(value instanceof ICartridge) || DisposeUtils.isDisposed((Control)this.nameLabel)) {
                return;
            }
            ICartridge embeddableCartridge = (ICartridge)value;
            String name = ExpressResourceLabelUtils.toString((ICartridge)embeddableCartridge);
            this.nameLabel.setText(name);
            this.nameLabel.setStyleRange(StyledTextUtils.createBoldStyle((String)name, null));
            this.description.setText(embeddableCartridge.getDescription());
        }

        public boolean isViewFor(Object object) {
            return object instanceof ICartridge;
        }

        /* synthetic */ CartridgeDetailsView(CartridgeDetailsView cartridgeDetailsView, CartridgeDetailsView cartridgeDetailsView2) {
            this();
        }
    }

    private class CodeAnythingDetailsView
    extends CartridgeDetailsView {
        private StyledText name;
        private StyledText description;
        private Text urlText;
        private Binding binding;

        private CodeAnythingDetailsView() {
            super(null, null);
        }

        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(container);
            this.name = new StyledText(container, 8);
            StyledTextUtils.setTransparent((StyledText)this.name);
            GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).grab(true, false).applyTo((Control)this.name);
            this.description = new StyledText(container, 586);
            this.description.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)this.description);
            GridDataFactory.fillDefaults().span(2, 1).align(4, 4).grab(true, true).applyTo((Control)this.description);
            Label urlLabel = new Label(container, 0);
            urlLabel.setText("Cartridge URL:");
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)urlLabel);
            this.urlText = new Text(container, 2048);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.urlText);
            ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)this.urlText)).notUpdatingParticipant()).to(CartridgeDetailViews.this.canModifyCartridges);
            return container;
        }

        @Override
        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            Object value = selectedCartridgeObservable.getValue();
            if (!(value instanceof CodeAnythingCartridge) || DisposeUtils.isDisposed((Control)this.name)) {
                return;
            }
            CodeAnythingCartridge cartridge = (CodeAnythingCartridge)value;
            String name = cartridge.getDisplayName();
            this.name.setText(name);
            this.name.setStyleRange(StyledTextUtils.createBoldStyle((String)name, null));
            this.description.setText(cartridge.getDescription());
            ISWTObservableValue urlTextObservable = WidgetProperties.text((int)24).observeDelayed(100, (Widget)this.urlText);
            this.binding = ValueBindingBuilder.bind((IObservableValue)urlTextObservable).to(BeanProperties.value((String)"urlString", String.class).observeDetail(selectedCartridgeObservable)).in(dbc);
            CodeAnythingUrlValidator codeAnythingUrlValidator = new CodeAnythingUrlValidator((IObservableValue)urlTextObservable, selectedCartridgeObservable);
            dbc.addValidationStatusProvider((ValidationStatusProvider)codeAnythingUrlValidator);
            ControlDecorationSupport.create((ValidationStatusProvider)codeAnythingUrlValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        }

        public void onInVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            DataBindingUtils.dispose((ValidationStatusProvider)this.binding);
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof CodeAnythingCartridge;
        }

        class CodeAnythingUrlValidator
        extends MultiValidator {
            private IObservableValue url;
            private IObservableValue selectedCartridge;

            private CodeAnythingUrlValidator(IObservableValue url, IObservableValue applicationTemplate) {
                this.url = url;
                this.selectedCartridge = applicationTemplate;
            }

            protected IStatus validate() {
                String url = (String)this.url.getValue();
                ICartridge cartridge = (ICartridge)this.selectedCartridge.getValue();
                if (!(cartridge instanceof CodeAnythingCartridge)) {
                    return ValidationStatus.ok();
                }
                if (StringUtils.isEmpty((String)url)) {
                    return ValidationStatus.cancel((String)"Please provide an url for your cartridge.");
                }
                if (!UrlUtils.isValid((String)url) && !EGitUtils.isValidGitUrl((String)url)) {
                    return ValidationStatus.error((String)NLS.bind((String)"{0} is not a valid url.", (Object)url));
                }
                return ValidationStatus.ok();
            }
        }
    }

    private class DownloadableCartridgeView
    extends CartridgeDetailsView {
        private StyledText name;
        private StyledText url;

        private DownloadableCartridgeView() {
            super(null, null);
        }

        @Override
        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().margins(10, 10).spacing(10, 10).applyTo(container);
            this.name = new StyledText(container, 8);
            StyledTextUtils.setTransparent((StyledText)this.name);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)this.name);
            this.url = new StyledText(container, 72);
            StyledTextUtils.setTransparent((StyledText)this.url);
            GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.url);
            return container;
        }

        @Override
        public void onVisible(IObservableValue selectedCartridgeObservable, DataBindingContext dbc) {
            Object value = selectedCartridgeObservable.getValue();
            if (!(value instanceof ICartridge) || DisposeUtils.isDisposed((Control)this.name)) {
                return;
            }
            ICartridge cartridge = (ICartridge)value;
            String cartridgeLabel = ExpressResourceLabelUtils.toString((ICartridge)cartridge);
            this.name.setText(cartridgeLabel);
            this.name.setStyleRange(StyledTextUtils.createBoldStyle((String)cartridgeLabel, null));
            if (cartridge.getUrl() != null) {
                this.url.setText(cartridge.getUrl().toString());
            }
        }

        @Override
        public boolean isViewFor(Object object) {
            return object instanceof ICartridge && ((ICartridge)object).isDownloadable();
        }
    }
}

