/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.OpenShiftEndpointException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.DomainWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.NewDomainWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.NewDomainWizardPage;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class NewDomainWizard
extends AbstractOpenShiftWizard<NewDomainWizardModel> {
    public NewDomainWizard(ExpressConnection connection) {
        super("Create Domain", (Object)new NewDomainWizardModel(connection));
    }

    public boolean performFinish() {
        AbstractDelegatingMonitorJob newDomainJob = new AbstractDelegatingMonitorJob(NLS.bind((String)"Creating domain {0}...", (Object)((NewDomainWizardModel)((Object)this.getModel())).getDomainId())){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    ((NewDomainWizardModel)((Object)NewDomainWizard.this.getModel())).createDomain();
                    return Status.OK_STATUS;
                }
                catch (OpenShiftEndpointException e) {
                    return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not create domain \"{0}\": {1}", (Object)((NewDomainWizardModel)((Object)NewDomainWizard.this.getModel())).getDomainId(), (Object)e.getRestResponseMessages()), e);
                }
            }
        };
        try {
            WizardUtils.runInWizard((Job)newDomainJob, (IWizardContainer)this.getContainer());
        }
        catch (Exception e) {
            Logger.error("Could not create domain", e);
        }
        return newDomainJob.getResult().isOK();
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewDomainWizardPage((DomainWizardModel)((Object)this.getModel()), (IWizard)this));
    }
}

