/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import com.openshift.client.IDomain;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.express.internal.ui.job.DestroyDomainJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.DestroyDomainDialog;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.EditDomainWizard;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.ManageDomainsWizardPageModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.NewDomainWizard;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;

public class ManageDomainsWizardPage
extends AbstractOpenShiftWizardPage {
    private ManageDomainsWizardPageModel pageModel;
    private TableViewer viewer;

    public ManageDomainsWizardPage(String title, String description, ManageDomainsWizardPageModel pageModel, IWizard wizard) {
        super(title, description, title, wizard);
        this.pageModel = pageModel;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        Group domainsGroup = new Group(parent, 0);
        domainsGroup.setText("Domains");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)domainsGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)domainsGroup);
        Composite tableContainer = new Composite((Composite)domainsGroup, 0);
        this.viewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setInput((Object)BeanProperties.list((String)"domains").observe((Object)this.pageModel));
        this.loadDomains(dbc);
        IViewerObservableValue viewerSingleSelection = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
        ValueBindingBuilder.bind((IObservableValue)viewerSingleSelection).to(BeanProperties.value((String)"selectedDomain").observe((Object)this.pageModel)).in(dbc);
        Button newButton = new Button((Composite)domainsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)newButton);
        newButton.setText("New...");
        newButton.addSelectionListener(this.onNew(dbc));
        Button editButton = new Button((Composite)domainsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)editButton);
        editButton.setText("Edit...");
        editButton.addSelectionListener(this.onEdit(dbc));
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editButton)).notUpdatingParticipant()).to((IObservableValue)viewerSingleSelection).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button removeButton = new Button((Composite)domainsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)removeButton);
        removeButton.setText("Remove...");
        removeButton.addSelectionListener(this.onRemove(dbc));
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).notUpdatingParticipant()).to((IObservableValue)viewerSingleSelection).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Composite filler = new Composite((Composite)domainsGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)filler);
        Button refreshButton = new Button((Composite)domainsGroup, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000008).applyTo((Control)refreshButton);
        refreshButton.setText("Refresh...");
        refreshButton.addSelectionListener(this.onRefresh(dbc));
    }

    private void loadDomains(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob("Loading domains..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    ManageDomainsWizardPage.this.pageModel.loadDomains();
                    return Status.OK_STATUS;
                }
            }, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (InvocationTargetException e) {
            Logger.error(NLS.bind((String)"Could not load domains for connection {0}", (Object)this.pageModel.getConnection().getId()), e);
        }
        catch (InterruptedException e) {
            Logger.error(NLS.bind((String)"Could not load domains for connection {0}", (Object)this.pageModel.getConnection().getId()), e);
        }
    }

    private SelectionListener onNew(DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardUtils.openWizardDialog((IWizard)new NewDomainWizard(ManageDomainsWizardPage.this.pageModel.getConnection()), (Shell)ManageDomainsWizardPage.this.getShell());
            }
        };
    }

    private SelectionListener onEdit(DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardUtils.openWizardDialog((IWizard)new EditDomainWizard(ManageDomainsWizardPage.this.pageModel.getSelectedDomain()), (Shell)ManageDomainsWizardPage.this.getShell());
            }
        };
    }

    private SelectionListener onRemove(final DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDomain domain = ManageDomainsWizardPage.this.pageModel.getSelectedDomain();
                if (domain == null) {
                    return;
                }
                DestroyDomainDialog dialog = new DestroyDomainDialog(domain, ManageDomainsWizardPage.this.getShell());
                dialog.open();
                if (dialog.isCancel()) {
                    return;
                }
                DestroyDomainJob deleteDomainJob = new DestroyDomainJob(domain, dialog.isForceDelete());
                try {
                    WizardUtils.runInWizard((Job)deleteDomainJob, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)deleteDomainJob.getDelegatingProgressMonitor(), (IWizardContainer)ManageDomainsWizardPage.this.getContainer(), (DataBindingContext)dbc);
                }
                catch (InvocationTargetException ex) {
                    Logger.error(NLS.bind((String)"Could not destroy domain {0}", (Object)domain.getId()), ex);
                }
                catch (InterruptedException ex) {
                    Logger.error(NLS.bind((String)"Could not destroy domain {0}", (Object)domain.getId()), ex);
                }
            }
        };
    }

    private SelectionListener onRefresh(final DataBindingContext dbc) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageDomainsWizardPage.this.refreshModel(dbc);
            }
        };
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IDomain>(){

            public String getValue(IDomain domain) {
                return domain.getId();
            }
        }).name("ID").align(16384).weight(1).minWidth(50).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IDomain>(){

            public String getValue(IDomain domain) {
                return domain.getSuffix();
            }
        }).name("Suffix").align(16384).weight(2).minWidth(100).buildColumn().buildViewer();
        return this.viewer;
    }

    private void refreshModel(DataBindingContext dbc) {
        try {
            WizardUtils.runInWizard((Job)new AbstractDelegatingMonitorJob("Refreshing domains..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    ManageDomainsWizardPage.this.pageModel.refresh();
                    return Status.OK_STATUS;
                }
            }, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)new DelegatingProgressMonitor(), (IWizardContainer)this.getContainer(), (DataBindingContext)dbc);
        }
        catch (InvocationTargetException ex) {
            Logger.error(NLS.bind((String)"Could not refresh connection {0}", (Object)this.pageModel.getConnection().getId()), ex);
        }
        catch (InterruptedException ex) {
            Logger.error(NLS.bind((String)"Could not refresh connection {0}", (Object)this.pageModel.getConnection().getId()), ex);
        }
    }

    public IDomain getSelectedDomain() {
        return this.pageModel.getSelectedDomain();
    }

    public void dispose() {
        this.pageModel.dispose();
        super.dispose();
    }
}

