/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.domain;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.DomainWizardModel;
import org.jboss.tools.openshift.express.internal.ui.wizard.domain.NewDomainWizardPage;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;

public class EditDomainWizardPage
extends NewDomainWizardPage {
    public EditDomainWizardPage(DomainWizardModel model, IWizard wizard) {
        super("OpenShift Domain Name", "Please provide a new name for your OpenShift domain", model, wizard);
    }

    @Override
    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        super.doCreateControls(parent, dbc);
        Link editMembersLink = new Link(parent, 0);
        editMembersLink.setText("<a>Edit domain members</a>");
        GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).applyTo((Control)editMembersLink);
        editMembersLink.addSelectionListener(this.onEditMembers());
    }

    private SelectionListener onEditMembers() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final GetUrlJob getURLJob = new GetUrlJob();
                new JobChainBuilder((Job)getURLJob).runWhenSuccessfullyDone((Job)new UIJob("Open Browser to Edit domain members"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        String webUIDomainPage = getURLJob.getWebUIDomainPageUrl();
                        if (webUIDomainPage != null) {
                            new BrowserUtility().checkedCreateExternalBrowser(webUIDomainPage, "org.jboss.tools.openshift.express.ui", ExpressUIActivator.getDefault().getLog());
                        } else {
                            new WebUIDomainPageNotFoundDialog(EditDomainWizardPage.this.getShell(), EditDomainWizardPage.this.getModel().getOriginWebUIDomainPageUrl()).open();
                        }
                        return Status.OK_STATUS;
                    }
                }).schedule();
            }
        };
    }

    private class GetUrlJob
    extends Job {
        private String webUIDomainPageUrl;

        public GetUrlJob() {
            super("Get Domain Web UI URL");
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.webUIDomainPageUrl = EditDomainWizardPage.this.getModel().getWebUIDomainPageUrl();
            return Status.OK_STATUS;
        }

        public String getWebUIDomainPageUrl() {
            return this.webUIDomainPageUrl;
        }
    }

    private class WebUIDomainPageNotFoundDialog
    extends MessageDialog {
        private String webUIDomainPageUrl;

        public WebUIDomainPageNotFoundDialog(Shell parentShell, String webUIDomainPageUrl) {
            super(parentShell, "Could not find web console", null, "Could not find the web page in the web console where you can edit your domain members.\nTo get there manually, please log into the web console and open the page that shows the details of your domain.\n" + (webUIDomainPageUrl != null ? "The url normally looks as follows:" : ""), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.webUIDomainPageUrl = webUIDomainPageUrl;
        }

        protected Control createCustomArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(container);
            if (this.webUIDomainPageUrl != null) {
                Link link = new Link(container, 0);
                link.setText("<a>" + this.webUIDomainPageUrl + "</a>");
                link.addSelectionListener(this.onLinkClicked(this.webUIDomainPageUrl));
                GridDataFactory.fillDefaults().indent(60, 0).applyTo((Control)link);
            }
            return container;
        }

        private SelectionListener onLinkClicked(final String webUIDomainPageUrl) {
            return new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new BrowserUtility().checkedCreateExternalBrowser(webUIDomainPageUrl, "org.jboss.tools.openshift.express.ui", ExpressUIActivator.getDefault().getLog());
                }
            };
        }
    }
}

