/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application.details;

import com.openshift.client.IApplication;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.openshift.express.internal.ui.ExpressImages;
import org.jboss.tools.openshift.express.internal.ui.propertytable.CopyPropertyAction;
import org.jboss.tools.openshift.express.internal.ui.propertytable.PropertyNameCellLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.propertytable.PropertyValueCellLabelProvider;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.details.ApplicationDetailsContentProvider;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class ApplicationDetailsDialog
extends TitleAreaDialog {
    private IApplication application;

    public ApplicationDetailsDialog(IApplication application, Shell parentShell) {
        super(parentShell);
        this.application = application;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setupDialog(parent);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Label titleSeparator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)titleSeparator);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(dialogArea);
        TreeViewer viewer = this.createApplicationDetailsTable(dialogArea);
        this.fillApplicationDetailsTable(viewer);
        Label buttonsSeparator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)buttonsSeparator);
        return dialogArea;
    }

    private void createContextMenu(TreeViewer viewer) {
        IMenuManager contextMenu = UIUtils.createContextMenu((Control)viewer.getControl());
        contextMenu.add((IAction)new CopyPropertyAction((ISelectionProvider)viewer));
    }

    private void fillApplicationDetailsTable(TreeViewer viewer) {
        viewer.setInput((Object)this.application);
        viewer.expandToLevel(2);
    }

    private TreeViewer createApplicationDetailsTable(Composite parent) {
        Composite tableContainer = new Composite(parent, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        tableContainer.setLayout((Layout)treeLayout);
        Tree tree = new Tree(tableContainer, 68352);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(500, 300).applyTo((Control)tableContainer);
        TreeViewer viewer = new TreeViewer(tree);
        this.createContextMenu(viewer);
        viewer.setContentProvider((IContentProvider)new ApplicationDetailsContentProvider());
        this.createTreeColumn("Property", 1, (CellLabelProvider)new PropertyNameCellLabelProvider(), viewer, treeLayout);
        this.createTreeColumn("Value", 3, (CellLabelProvider)new PropertyValueCellLabelProvider(), viewer, treeLayout);
        return viewer;
    }

    private void createTreeColumn(String name, int weight, CellLabelProvider cellLabelProvider, TreeViewer treeViewer, TreeColumnLayout layout) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, 16384);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(name);
        column.setResizable(true);
        viewerColumn.setLabelProvider(cellLabelProvider);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, weight * 200, true));
    }

    private void setupDialog(Composite parent) {
        parent.getShell().setText("Application Details");
        this.setTitle(NLS.bind((String)"Details of Application {0}", (Object)this.application.getName()));
        this.setTitleImage(ExpressImages.OPENSHIFT_LOGO_WHITE_MEDIUM_IMG);
        ApplicationDetailsDialog.setDialogHelpAvailable((boolean)false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

