/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard.application;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.common.ui.databinding.ObservableUIPojo;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.utils.PojoEventBridge;
import org.jboss.tools.openshift.express.internal.ui.wizard.application.OpenShiftApplicationWizardModel;

public class SelectApplicationWizardPageModel
extends ObservableUIPojo {
    public static final String PROPERTY_DOMAINS = "domains";
    public static final String PROPERTY_SELECTED_APPLICATION = "selectedApplication";
    private IApplication selectedApplication;
    private OpenShiftApplicationWizardModel wizardModel;

    public SelectApplicationWizardPageModel(OpenShiftApplicationWizardModel wizardModel) {
        this.selectedApplication = wizardModel.getApplication();
        this.wizardModel = wizardModel;
        new PojoEventBridge().listenTo(PROPERTY_DOMAINS, wizardModel).forwardTo(PROPERTY_DOMAINS, (ObservablePojo)this);
    }

    public void refresh() {
        this.refreshDomains();
        this.selectedApplication = null;
    }

    private void refreshDomains() {
        ExpressConnection connection = this.wizardModel.getConnection();
        if (connection == null) {
            return;
        }
        connection.refresh();
        this.wizardModel.setDomains(this.loadDomains(connection));
    }

    public List<IDomain> getDomains() throws OpenShiftException {
        return this.wizardModel.getDomains();
    }

    public IApplication getSelectedApplication() {
        return this.selectedApplication;
    }

    public void setSelectedApplication(IApplication application) {
        this.selectedApplication = application;
        this.firePropertyChange(PROPERTY_SELECTED_APPLICATION, this.selectedApplication, this.selectedApplication);
    }

    public void loadOpenShiftResources() {
        this.loadDomains(this.wizardModel.getConnection());
    }

    protected List<IDomain> loadDomains(ExpressConnection connection) {
        if (connection == null) {
            return Collections.emptyList();
        }
        List domains = connection.getDomains();
        this.wizardModel.setDomains(domains);
        return domains;
    }

    public ExpressConnection getConnection() {
        return this.wizardModel.getConnection();
    }

    public void clearSelectedApplication() {
        this.setSelectedApplication(null);
    }
}

