/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.wizard;

import com.openshift.client.IApplication;
import com.openshift.client.IField;
import com.openshift.client.ISeverity;
import com.openshift.client.Message;
import com.openshift.client.Messages;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.express.internal.ui.wizard.CreationLogDialog;

public class LogEntryFactory {
    public static CreationLogDialog.LogEntry[] create(IApplication application, boolean isTimeouted) {
        CreationLogDialog.LogEntry[] logEntry = new CreationLogDialog.LogEntry[]{};
        if (application != null) {
            ArrayList<CreationLogDialog.LogEntry> entries = new ArrayList<CreationLogDialog.LogEntry>();
            List<Message> messages = LogEntryFactory.getMessages(application.getMessages());
            if (messages != null) {
                for (Message message : messages) {
                    if (message != null && !StringUtils.isEmpty((String)message.getText())) {
                        entries.add(new CreationLogDialog.LogEntry(application.getName(), message.getText(), isTimeouted, application));
                        continue;
                    }
                    if (!isTimeouted) continue;
                    entries.add(new CreationLogDialog.LogEntry(application.getName(), null, isTimeouted, application));
                }
            } else if (isTimeouted) {
                entries.add(new CreationLogDialog.LogEntry(application.getName(), null, isTimeouted, application));
            }
            return entries.toArray(new CreationLogDialog.LogEntry[entries.size()]);
        }
        return logEntry;
    }

    public static CreationLogDialog.LogEntry[] create(Collection<IEmbeddedCartridge> cartridges, boolean isTimeouted) {
        if (cartridges == null || cartridges.isEmpty()) {
            return new CreationLogDialog.LogEntry[0];
        }
        ArrayList<CreationLogDialog.LogEntry> entries = new ArrayList<CreationLogDialog.LogEntry>();
        for (IEmbeddedCartridge cartridge : cartridges) {
            List<Message> messages = LogEntryFactory.getMessages(cartridge.getMessages());
            if (messages != null) {
                for (Message message : messages) {
                    if (message != null && !StringUtils.isEmpty((String)message.getText())) {
                        entries.add(new CreationLogDialog.LogEntry(cartridge.getName(), message.getText(), isTimeouted, cartridge));
                        continue;
                    }
                    if (!isTimeouted) continue;
                    entries.add(new CreationLogDialog.LogEntry(cartridge.getName(), null, isTimeouted, cartridge));
                }
                continue;
            }
            if (!isTimeouted) continue;
            entries.add(new CreationLogDialog.LogEntry(cartridge.getName(), null, isTimeouted, cartridge));
        }
        return entries.toArray(new CreationLogDialog.LogEntry[entries.size()]);
    }

    private static List<Message> getMessages(Messages messages) {
        if (messages == null) {
            return null;
        }
        List resultMessages = messages.getBy(IField.RESULT);
        if (resultMessages == null || resultMessages.isEmpty()) {
            resultMessages = messages.getBy(IField.DEFAULT, ISeverity.RESULT);
        }
        return resultMessages;
    }
}

