/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.property;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftSSHOperationException;
import com.openshift.client.cartridge.ICartridge;
import java.text.SimpleDateFormat;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.jboss.tools.openshift.express.internal.core.util.ExpressResourceLabelUtils;

public class ApplicationPropertySource
implements IPropertySource {
    private final IApplication application;

    public ApplicationPropertySource(IApplication adaptableObject) {
        this.application = adaptableObject;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new PropertyDescriptor((Object)"3.URL", "Public URL"), new PropertyDescriptor((Object)"1.Name", "Name"), new PropertyDescriptor((Object)"6.UUID", "UUID"), new PropertyDescriptor((Object)"5.Git URL", "Git URL"), new PropertyDescriptor((Object)"2.Type", "Type"), new PropertyDescriptor((Object)"4.Created on", "Created on"), new PropertyDescriptor((Object)"7.Port Forwarding", "Port Forwarding"), new PropertyDescriptor((Object)"8.Scalable", "Scalable")};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("3.URL")) {
            return this.application.getApplicationUrl().toString();
        }
        if (id.equals("1.Name")) {
            return this.application.getName();
        }
        if (id.equals("6.UUID")) {
            return this.application.getUUID();
        }
        if (id.equals("4.Created on")) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss");
            return format.format(this.application.getCreationTime());
        }
        if (id.equals("2.Type")) {
            return ExpressResourceLabelUtils.toString((ICartridge)this.application.getCartridge());
        }
        if (id.equals("5.Git URL")) {
            return this.application.getGitUrl();
        }
        if (id.equals("7.Port Forwarding")) {
            try {
                StringBuffer bf = new StringBuffer();
                boolean portFowardingStarted = this.application.isPortFowardingStarted();
                if (portFowardingStarted) {
                    return bf.append("Yes");
                }
                if (!portFowardingStarted) {
                    return bf.append("No");
                }
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {
                return "Unknown";
            }
        }
        if (id.equals("8.Scalable")) {
            return this.application.getApplicationScale() != null ? this.application.getApplicationScale().getValue() : "";
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

