/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.job;

import com.openshift.client.IApplication;
import com.openshift.client.OpenShiftException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.job.LoadApplicationJob;
import org.jboss.tools.openshift.express.internal.ui.utils.Logger;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public abstract class AbstratApplicationJob
extends AbstractDelegatingMonitorJob {
    private ApplicationProvider applicationProvider;

    protected AbstratApplicationJob(ApplicationProvider applicationProvider, String name) {
        super(name);
        this.applicationProvider = applicationProvider;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        Logger.debug(this.getName());
        IApplication application = null;
        try {
            application = this.applicationProvider.getApplication();
            if (application != null) {
                this.doRun(application);
            }
        }
        catch (OpenShiftException e) {
            return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not {0}", (Object)this.getName()), e);
        }
        return Status.OK_STATUS;
    }

    protected abstract void doRun(IApplication var1);

    public static class ApplicationProvider {
        private IApplication application;
        private LoadApplicationJob applicationJob;

        public ApplicationProvider(IApplication application) {
            this.application = application;
        }

        public ApplicationProvider(LoadApplicationJob applicationJob) {
            this.applicationJob = applicationJob;
        }

        public IApplication getApplication() {
            if (this.application != null) {
                return this.application;
            }
            return this.applicationJob.getApplication();
        }
    }
}

