/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.ui.command;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.fragment.ModifyModulesWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.NewServerWizardFragment;
import org.eclipse.wst.server.ui.internal.wizard.fragment.TasksWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.express.core.util.ExpressConnectionUtils;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.ui.ExpressUIActivator;
import org.jboss.tools.openshift.express.internal.ui.server.ExpressServerWizardTaskModelUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;

public class NewServerAdapterHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IApplication application = (IApplication)UIUtils.getFirstElement((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event), IApplication.class);
        if (application == null) {
            return ExpressUIActivator.createCancelStatus("Cannot create server adapter: no application selected.");
        }
        try {
            NewServerWizard wizard = new NewServerWizard("org.jboss.tools.openshift.express.openshift.server.type");
            ExpressServerWizardTaskModelUtil.put(application, wizard.getTaskModel());
            IDomain domain = application.getDomain();
            ExpressServerWizardTaskModelUtil.put(domain, wizard.getTaskModel());
            ExpressConnection connection = ExpressConnectionUtils.getByResource((IApplication)application, (ConnectionsRegistry)ConnectionsRegistrySingleton.getInstance());
            if (connection == null) {
                return ExpressUIActivator.createCancelStatus(NLS.bind((String)"Cannot create server adapter: connection for application {0} not found.", (Object)application.getName()));
            }
            ExpressServerWizardTaskModelUtil.put(connection, wizard.getTaskModel());
            WizardUtils.openWizardDialog((int)400, (int)700, (IWizard)wizard, (Shell)HandlerUtil.getActiveShell((ExecutionEvent)event));
            return Status.OK_STATUS;
        }
        catch (OpenShiftException e) {
            return ExpressUIActivator.createErrorStatus(NLS.bind((String)"Could not create OpenShift server adapter for application {0}", (Object)application.getName()), e);
        }
    }

    public class NewServerWizard
    extends TaskWizard
    implements INewWizard {
        public NewServerWizard(final String serverType) {
            super(Messages.wizNewServerWizardTitle, new WizardFragment(){

                protected void createChildFragments(List<WizardFragment> list) {
                    list.add((WizardFragment)new NewServerWizardFragment(null, serverType));
                    list.add(WizardTaskUtil.TempSaveRuntimeFragment);
                    list.add(WizardTaskUtil.TempSaveServerFragment);
                    list.add((WizardFragment)new ModifyModulesWizardFragment());
                    list.add((WizardFragment)new TasksWizardFragment());
                    list.add(WizardTaskUtil.SaveRuntimeFragment);
                    list.add(WizardTaskUtil.SaveServerFragment);
                    list.add(WizardTaskUtil.SaveHostnameFragment);
                }
            });
        }

        public void init(IWorkbench newWorkbench, IStructuredSelection newSelection) {
        }
    }
}

