/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.edit;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.ViewIDValidator;
import org.jboss.tools.seam.ui.pages.editor.figures.ExceptionFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.figures.PageFigure;

public class ViewIDEditManager
extends DirectEditManager {
    private IActionBars actionBars;
    private CellEditorActionHandler actionHandler;
    private IAction copy;
    private IAction cut;
    private IAction paste;
    private IAction undo;
    private IAction redo;
    private IAction find;
    private IAction selectAll;
    private IAction delete;
    private double cachedZoom = -1.0;
    private Font scaledFont;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            ViewIDEditManager.this.updateScaledFont(newZoom);
        }
    };
    private XModelObject target;
    private boolean rename = false;

    public ViewIDEditManager(GraphicalEditPart source, CellEditorLocator locator) {
        super(source, null, locator);
        this.target = (XModelObject)((PagesDiagramEditPart)source.getParent()).getPagesModel().getData();
    }

    public ViewIDEditManager(GraphicalEditPart source, CellEditorLocator locator, boolean rename) {
        this(source, locator);
        this.rename = rename;
    }

    protected DirectEditRequest createDirectEditRequest() {
        DirectEditRequest req = super.createDirectEditRequest();
        if (this.rename) {
            req.getExtendedData().put("rename", new Boolean(true));
        }
        return req;
    }

    protected void bringDown() {
        if (this.getEditPart().getParent() == null) {
            return;
        }
        ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.removeZoomListener(this.zoomListener);
        }
        if (this.actionHandler != null) {
            this.actionHandler.dispose();
            this.actionHandler = null;
        }
        if (this.actionBars != null) {
            this.restoreSavedActions(this.actionBars);
            this.actionBars.updateActionBars();
            this.actionBars = null;
        }
        super.bringDown();
        this.disposeScaledFont();
        PagesElement element = ((PagesEditPart)this.getEditPart()).getElementModel();
        if (!this.rename) {
            element.setParent(null);
        }
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 68){

            protected void setErrorMessage(String message) {
                super.setErrorMessage(message);
                ((WorkbenchWindow)Workbench.getInstance().getActiveWorkbenchWindow()).getStatusLineManager().setErrorMessage(message);
            }

            protected void editOccured(ModifyEvent e) {
                String value = this.text.getText();
                if (value == null) {
                    value = "";
                }
                String typedValue = value;
                boolean oldValidState = this.isValueValid();
                boolean newValidState = this.isCorrect(typedValue);
                if (typedValue == null && newValidState) {
                    Assert.isTrue((boolean)false, (String)"Validator isn't limiting the cell editor's type range");
                }
                if (!newValidState) {
                    this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
                } else {
                    this.setErrorMessage("");
                    this.valueChanged(oldValidState, newValidState);
                }
            }

            protected Control createControl(Composite parent) {
                Control control = super.createControl(parent);
                control.setBackground(ColorConstants.white);
                this.setErrorMessage("");
                return control;
            }
        };
    }

    private void disposeScaledFont() {
        if (this.scaledFont != null) {
            this.scaledFont.dispose();
            this.scaledFont = null;
        }
    }

    protected void initCellEditor() {
        NodeFigure figure = (NodeFigure)this.getEditPart().getFigure();
        if (figure instanceof PageFigure && ((PageFigure)figure).page.getName() != null) {
            this.getCellEditor().setValue((Object)((PageFigure)figure).page.getName());
        } else if (figure instanceof ExceptionFigure && ((ExceptionFigure)figure).exc.getName() != null) {
            this.getCellEditor().setValue((Object)((ExceptionFigure)figure).exc.getName());
        } else {
            this.getCellEditor().setValue((Object)"");
        }
        ZoomManager zoomMgr = (ZoomManager)this.getEditPart().getViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            this.cachedZoom = -1.0;
            this.updateScaledFont(zoomMgr.getZoom());
            zoomMgr.addZoomListener(this.zoomListener);
        } else {
            this.getCellEditor().getControl().setFont(figure.getFont());
        }
        this.actionBars = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars();
        this.saveCurrentActions(this.actionBars);
        this.actionHandler = new CellEditorActionHandler(this.actionBars);
        this.actionHandler.addCellEditor(this.getCellEditor());
        this.actionBars.updateActionBars();
        this.getCellEditor().setValidator((ICellEditorValidator)new ViewIDValidator(this.target));
        if (figure instanceof PageFigure) {
            XAttribute attr = this.target.getModel().getMetaData().getEntity("SeamPage21").getAttribute("view id");
            AttributeContentProposalProviderFactory.registerContentAssist((XModelObject)this.target, null, (XAttribute)attr, (Control)this.getCellEditor().getControl());
        } else if (figure instanceof ExceptionFigure) {
            IProject project = (IProject)this.target.getModel().getProperties().get("project");
            PDEJavaHelperUI.addTypeFieldAssistToText((Text)((Text)this.getCellEditor().getControl()), (IProject)project, (int)5);
        }
    }

    private void restoreSavedActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.copy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.paste);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delete);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAll);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.cut);
        actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.find);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.redo);
    }

    private void saveCurrentActions(IActionBars actionBars) {
        this.copy = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
        this.paste = actionBars.getGlobalActionHandler(ActionFactory.PASTE.getId());
        this.delete = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.selectAll = actionBars.getGlobalActionHandler(ActionFactory.SELECT_ALL.getId());
        this.cut = actionBars.getGlobalActionHandler(ActionFactory.CUT.getId());
        this.find = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        this.undo = actionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
        this.redo = actionBars.getGlobalActionHandler(ActionFactory.REDO.getId());
    }

    private void updateScaledFont(double zoom) {
        if (this.cachedZoom == zoom) {
            return;
        }
        Text text = (Text)this.getCellEditor().getControl();
        Font font = this.getEditPart().getFigure().getFont();
        this.disposeScaledFont();
        this.cachedZoom = zoom;
        if (zoom == 1.0) {
            text.setFont(font);
        } else {
            FontData fd = font.getFontData()[0];
            fd.setHeight((int)((double)fd.getHeight() * zoom));
            this.scaledFont = new Font(null, fd);
            text.setFont(this.scaledFont);
        }
    }
}

