/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.openshift.common.core.utils.FileUtils;

public class ResourceUtils {
    public static boolean exists(IResource resource) {
        return resource != null && resource.isAccessible();
    }

    public static boolean isDirectory(IResource resource) {
        return resource != null && resource.getType() == 2;
    }

    public static void copy(IResource source, IResource destination, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        if (!ResourceUtils.exists(source) || destination == null) {
            return;
        }
        if (ResourceUtils.isDirectory(source)) {
            ResourceUtils.copyDirectory((IFolder)source, (IFolder)destination, overwrite, monitor);
        } else {
            ResourceUtils.copyFile((IFile)source, destination, overwrite, monitor);
        }
    }

    private static void copyDirectory(IFolder source, IFolder destination, final boolean overwrite, final IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((boolean)ResourceUtils.isDirectory((IResource)source));
        Assert.isLegal((boolean)ResourceUtils.isDirectory((IResource)destination));
        final IFolder destinationFolder = ResourceUtils.getDestinationFolder(source, destination);
        if (!destinationFolder.exists()) {
            destinationFolder.create(ResourceUtils.getForceFlag(overwrite), true, monitor);
        }
        source.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (ResourceUtils.isDirectory(resource)) {
                    ResourceUtils.copyDirectory((IFolder)resource, destinationFolder.getFolder(resource.getName()), overwrite, monitor);
                } else {
                    ResourceUtils.copyFile((IFile)resource, (IResource)destinationFolder.getFile(resource.getName()), overwrite, monitor);
                }
                return true;
            }
        });
    }

    private static IFolder getDestinationFolder(IFolder source, IFolder destination) {
        if (!source.getName().equals(destination.getName())) {
            destination = destination.getFolder(source.getName());
        }
        return destination;
    }

    private static void copyFile(IFile source, IResource destination, boolean overwrite, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((source != null ? 1 : 0) != 0);
        Assert.isLegal((destination != null ? 1 : 0) != 0);
        destination = ResourceUtils.getDestination(source, destination);
        if (ResourceUtils.exists(destination) && !overwrite) {
            return;
        }
        if (ResourceUtils.isDirectory(destination)) {
            if (!overwrite) {
                return;
            }
            destination.delete(1, monitor);
        }
        source.copy(destination.getFullPath(), ResourceUtils.getForceFlag(overwrite), monitor);
    }

    private static IResource getDestination(IFile source, IResource destination) {
        if (!source.getName().equals(destination.getName()) && destination.getType() == 2) {
            destination = ((IFolder)destination).getFile(source.getName());
        }
        return destination;
    }

    private static int getForceFlag(boolean overwrite) {
        if (overwrite) {
            return 1;
        }
        return 0;
    }

    public static Collection<IResource> copy(File sourceFolder, String[] sourcePaths, IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        File projectFolder = project.getLocation().toFile();
        String[] stringArray = sourcePaths;
        int n = sourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String sourcePath = stringArray[n2];
            File source = new File(sourceFolder, sourcePath);
            if (FileUtils.canRead((File)source)) {
                FileUtils.copy((File)source, (File)projectFolder, (boolean)false);
                if (source.isDirectory()) {
                    resources.add((IResource)project.getFolder(sourcePath));
                } else {
                    resources.add((IResource)project.getFile(sourcePath));
                }
            }
            ++n2;
        }
        project.refreshLocal(2, monitor);
        return resources;
    }
}

