/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.util;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class OpenShiftProjectUtils {
    private static final String FOLDER_DOT_OPENSHIFT = ".openshift";
    private static final String FOLDER_MARKERS = ".openshift" + File.separatorChar + "markers";

    public static boolean isOpenShiftProject(IProject project) {
        IFolder folder = OpenShiftProjectUtils.getOpenShiftFolder(project);
        return folder != null && folder.isAccessible();
    }

    public static IFolder getOpenShiftFolder(IProject project) {
        return project.getFolder(FOLDER_DOT_OPENSHIFT);
    }

    public static IFolder getMarkersFolder(IProject project) {
        return project.getFolder((IPath)new Path(FOLDER_MARKERS));
    }

    public static IFolder ensureMarkersFolderExists(IProject project, IProgressMonitor monitor) throws CoreException {
        OpenShiftProjectUtils.ensureExists(OpenShiftProjectUtils.getOpenShiftFolder(project), monitor);
        return OpenShiftProjectUtils.ensureExists(OpenShiftProjectUtils.getMarkersFolder(project), monitor);
    }

    private static IFolder ensureExists(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.isAccessible()) {
            folder.create(false, true, monitor);
        }
        return folder;
    }
}

