/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.internal.core.server;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.tools.openshift.express.internal.core.server.ExpressServerPublishMethod;

public class ExpressServerBehaviour
extends ServerBehaviourDelegate {
    private IAdaptable publishAdaptableInfo;
    private ExpressServerPublishMethod publishMethod;

    public IStatus publish(int kind, IProgressMonitor monitor) {
        boolean shouldPublish = false;
        if (this.publishAdaptableInfo != null) {
            shouldPublish = "user".equals(this.publishAdaptableInfo.getAdapter(String.class));
        }
        if (shouldPublish) {
            return super.publish(kind, monitor);
        }
        return Status.OK_STATUS;
    }

    public void publish(int kind, List<IModule[]> modules, IProgressMonitor monitor, IAdaptable info) throws CoreException {
        this.publishAdaptableInfo = info;
        try {
            super.publish(kind, modules, monitor, info);
        }
        finally {
            this.publishAdaptableInfo = null;
        }
    }

    public IAdaptable getPublishAdaptableInfo() {
        return this.publishAdaptableInfo;
    }

    public boolean canRestartModule(IModule[] module) {
        return module.length == 1;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
    }

    public void stop(boolean force) {
    }

    private ExpressServerPublishMethod getPublishMethod() {
        if (this.publishMethod == null) {
            this.publishMethod = new ExpressServerPublishMethod();
        }
        return this.publishMethod;
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
        this.getPublishMethod().publishStart(this.getServer(), monitor);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        int state = this.getPublishMethod().publishModule(this.getServer(), kind, deltaKind, module, monitor);
        this.setModulePublishState(module, state);
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        this.getPublishMethod().publishFinish(this.getServer(), monitor);
    }

    public IStatus canStart(String launchMode) {
        return Status.CANCEL_STATUS;
    }

    public IStatus canRestart(String mode) {
        return Status.CANCEL_STATUS;
    }

    public IStatus canStop() {
        return Status.CANCEL_STATUS;
    }
}

