/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.core.util;

import com.openshift.client.IApplication;
import com.openshift.client.IUser;
import com.openshift.client.configuration.OpenShiftConfiguration;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.OpenShiftCoreException;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistry;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;
import org.jboss.tools.openshift.express.internal.core.connection.ExpressConnection;
import org.jboss.tools.openshift.express.internal.core.preferences.ExpressCorePreferences;

public class ExpressConnectionUtils {
    private ExpressConnectionUtils() {
    }

    public static ExpressConnection getByResource(IApplication application, ConnectionsRegistry connectionsRegistry) {
        if (application == null) {
            return null;
        }
        return ExpressConnectionUtils.getByResource(application.getDomain().getUser(), connectionsRegistry);
    }

    public static ExpressConnection getByResource(IUser user, ConnectionsRegistry connectionsRegistry) throws OpenShiftCoreException {
        if (user == null) {
            return null;
        }
        try {
            ConnectionURL connectionUrl = ConnectionURL.forUsernameAndHost((String)user.getRhlogin(), (String)user.getServer());
            ExpressConnection connection = (ExpressConnection)connectionsRegistry.getByUrl(connectionUrl, ExpressConnection.class);
            String defaultHost = ExpressConnectionUtils.getDefaultHostUrl();
            if (connection == null && defaultHost.equals(user.getServer())) {
                connectionUrl = ConnectionURL.forUsername((String)user.getRhlogin());
                connection = (ExpressConnection)connectionsRegistry.getByUrl(connectionUrl, ExpressConnection.class);
            }
            return connection;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException((Throwable)e, NLS.bind((String)"Could not get connection for user resource {0} - {1}", (Object)user.getRhlogin(), (Object)user.getServer()), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException((Throwable)e, NLS.bind((String)"Could not get connection for user resource {0} - {1}", (Object)user.getRhlogin(), (Object)user.getServer()), new Object[0]);
        }
    }

    public static ExpressConnection getByUrl(ConnectionURL connectionUrl, ConnectionsRegistry connectionsRegistry) {
        if (connectionUrl == null) {
            return null;
        }
        return (ExpressConnection)connectionsRegistry.getByUrl(connectionUrl, ExpressConnection.class);
    }

    public static ExpressConnection getByUsername(String username, ConnectionsRegistry connectionsRegistry) {
        try {
            return ExpressConnectionUtils.getByUrl(ConnectionURL.forUsername((String)username), connectionsRegistry);
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(NLS.bind((String)"Could not get url for connection {0}", (Object)username), new Object[]{e});
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(NLS.bind((String)"Could not get url for connection {0}", (Object)username), new Object[]{e});
        }
    }

    public static String getDefaultHostUrl() {
        try {
            String defaultHost = ExpressCorePreferences.INSTANCE.getDefaultHost();
            if (!StringUtils.isEmpty((String)defaultHost)) {
                return defaultHost;
            }
            return new OpenShiftConfiguration().getLibraServer();
        }
        catch (IOException e) {
            ExpressCoreActivator.pluginLog().logError("Could not load default server from OpenShift configuration.", (Throwable)e);
            return null;
        }
    }

    public static boolean isDefaultHost(String host) {
        return UrlUtils.isEmptyHost((String)host) || ExpressConnectionUtils.getDefaultHostUrl().equals(UrlUtils.ensureStartsWithScheme((String)host, (String)"https://"));
    }
}

