/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.core;

import com.openshift.client.IHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.openshift.common.core.ICredentialsPrompter;
import org.jboss.tools.openshift.express.core.IConsoleUtility;
import org.jboss.tools.openshift.express.core.IEGitUI;
import org.jboss.tools.openshift.express.core.IQuestionHandler;
import org.jboss.tools.openshift.express.internal.core.ExpressCoreActivator;

public class ExpressCoreUIIntegration {
    private static final String EGITUI_ID = "org.jboss.tools.openshift.express.core.ui.egit";
    private static ExpressCoreUIIntegration INSTANCE = new ExpressCoreUIIntegration();
    private IConsoleUtility consoleUtil;
    private IQuestionHandler questionHandler;
    private ICredentialsPrompter credentialPrompter;
    private IHttpClient.ISSLCertificateCallback sslCertificateCallback;

    public static ExpressCoreUIIntegration getDefault() {
        return INSTANCE;
    }

    public ICredentialsPrompter getCredentialPrompter() {
        return this.credentialPrompter;
    }

    public void setCredentialPrompter(ICredentialsPrompter prompter) {
        this.credentialPrompter = prompter;
    }

    public IHttpClient.ISSLCertificateCallback getSSLCertificateCallback() {
        return this.sslCertificateCallback;
    }

    public void setSSLCertificateAuthorization(IHttpClient.ISSLCertificateCallback authorization) {
        this.sslCertificateCallback = authorization;
    }

    public void setConsoleUtility(IConsoleUtility util) {
        this.consoleUtil = util;
    }

    public IConsoleUtility getConsoleUtility() {
        return this.consoleUtil;
    }

    public IQuestionHandler getQuestionHandler() {
        return this.questionHandler;
    }

    public void setQuestionHandler(IQuestionHandler questionHandler) {
        this.questionHandler = questionHandler;
    }

    public IEGitUI getEGitUI() throws CoreException {
        IEGitUI egitUI = (IEGitUI)this.getConfigurationElement(this.getExtension(EGITUI_ID));
        if (egitUI == null) {
            throw new CoreException(ExpressCoreActivator.statusFactory().errorStatus("Could not find extension org.jboss.tools.openshift.express.core.ui.egit"));
        }
        return egitUI;
    }

    private IConfigurationElement[] getExtension(String name) {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(name);
    }

    private <T> T getConfigurationElement(IConfigurationElement[] configurations) throws CoreException {
        Object element = null;
        if (configurations != null) {
            IConfigurationElement[] iConfigurationElementArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configuration = iConfigurationElementArray[n2];
                element = configuration.createExecutableExtension("class");
                ++n2;
            }
        }
        return (T)element;
    }

    public static void displayConsoleView(IServer server) {
        IConsoleUtility util = ExpressCoreUIIntegration.getDefault().getConsoleUtility();
        if (util != null) {
            util.displayServerConsoleView(server);
        }
    }

    public static OutputStream getConsoleOutputStream(IServer server) {
        IConsoleUtility util = ExpressCoreUIIntegration.getDefault().getConsoleUtility();
        OutputStream os = null;
        if (util != null) {
            os = util.getServerConsoleOutputStream(server);
        }
        return os == null ? new ByteArrayOutputStream() : os;
    }

    public static void appendToConsole(IServer server, String msg) {
        IConsoleUtility util = ExpressCoreUIIntegration.getDefault().getConsoleUtility();
        if (util != null) {
            util.appendToServerConsole(server, msg);
        }
    }

    public static boolean requestApproval(String message, String title) {
        return ExpressCoreUIIntegration.requestApproval(message, title, true);
    }

    public static boolean requestApproval(String message, String title, boolean defaultAnswer) {
        return ExpressCoreUIIntegration.openQuestion(title, message, defaultAnswer);
    }

    private static boolean openQuestion(String title, String message, boolean defaultAnswer) {
        IQuestionHandler handler = ExpressCoreUIIntegration.getDefault().getQuestionHandler();
        return handler == null ? false : handler.openQuestion(title, message, defaultAnswer);
    }

    public static void openCommitDialog(IProject project, String remote, String applicationName, Job pushJob) throws CoreException {
        ExpressCoreUIIntegration.getDefault().getEGitUI().publish(project, remote, applicationName, pushJob);
    }
}

