/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;

public class SourceLookupUtil {
    public void addSelectedProjects(ILaunchConfigurationWorkingCopy wc, IJavaElement[] selection, IJavaProject javaProject) throws CoreException {
        if (selection == null || selection.length == 0) {
            wc.setAttribute("selectedProjects", null);
        } else {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ISourceLookupDirector director = this.addSourceContainers(manager, wc, selection, javaProject);
            if (director != null) {
                wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
                wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            }
        }
    }

    private ISourceLookupDirector addSourceContainers(ILaunchManager manager, ILaunchConfigurationWorkingCopy wc, IJavaElement[] selection, IJavaProject javaProject) throws CoreException {
        String memento = null;
        String locatorId = null;
        try {
            memento = wc.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
            locatorId = wc.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (locatorId == null) {
                locatorId = wc.getType().getSourceLocatorId();
            }
        }
        catch (CoreException e) {
            RemoteDebugActivator.pluginLog().logError((Throwable)e);
        }
        IPersistableSourceLocator locator = manager.newSourceLocator(locatorId);
        if (memento != null) {
            locator.initializeFromMemento(memento);
        } else {
            locator.initializeDefaults((ILaunchConfiguration)wc);
        }
        if (locator instanceof AbstractSourceLookupDirector) {
            ISourceLookupDirector director = (ISourceLookupDirector)locator;
            ArrayList<ISourceContainer> sourceContainers = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
            LinkedHashSet<String> projectNames = new LinkedHashSet<String>();
            if (javaProject != null) {
                projectNames.add(javaProject.getElementName());
            }
            int i = 0;
            while (i < selection.length) {
                IJavaProject project = selection[i].getJavaProject();
                if (project instanceof IJavaProject && !project.equals(javaProject)) {
                    projectNames.add(project.getElementName());
                    sourceContainers.add((ISourceContainer)new JavaProjectSourceContainer(project));
                }
                ++i;
            }
            director.setSourceContainers(sourceContainers.toArray(new ISourceContainer[sourceContainers.size()]));
            director.setFindDuplicates(true);
            ArrayList<String> projectsList = new ArrayList<String>();
            projectsList.addAll(projectNames);
            wc.setAttribute("selectedProjects", projectsList);
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            return director;
        }
        RemoteDebugActivator.pluginLog().logWarning("Launch configuration doesn't support source lookup");
        return null;
    }
}

