/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.validation;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.jst.web.validation.CheckClass;
import org.jboss.tools.jst.web.validation.CheckServletClass;
import org.jboss.tools.jst.web.validation.WebXMLValidatorMessages;

public class CheckServletMappingName
extends Check {
    public static String JAX_RS_APPLICATION = "javax.ws.rs.core.Application";
    static String ATTR = "servlet-name";
    boolean acceptEmpty = false;

    public CheckServletMappingName(ValidationErrorManager manager, String preference, boolean acceptEmpty) {
        super(manager, preference, ATTR);
        this.acceptEmpty = acceptEmpty;
    }

    @Override
    public void check(XModelObject object) {
        String servletName = object.getAttributeValue(ATTR);
        if (servletName == null) {
            return;
        }
        if (servletName.length() == 0) {
            if (this.acceptEmpty) {
                return;
            }
            this.fireMessage(object, WebXMLValidatorMessages.EMPTY, this.attr);
        } else if (this.findServlet(object, servletName) == null) {
            if (servletName.equals(JAX_RS_APPLICATION)) {
                return;
            }
            IType type = CheckClass.getValidType(servletName, object);
            if (type != null) {
                try {
                    new CheckServletClass(this.manager).check(object, servletName, type);
                }
                catch (JavaModelException e) {
                    WebModelPlugin.getDefault().logError(e);
                }
            } else {
                this.fireMessage(object, WebXMLValidatorMessages.SERVLET_NOT_EXISTS, this.attr, servletName);
            }
        }
    }

    XModelObject findServlet(XModelObject mapping, String name) {
        XModelObject webxml = WebAppHelper.getParentFile(mapping);
        XModelObject[] cs = WebAppHelper.getServlets(webxml);
        int i = 0;
        while (i < cs.length) {
            if (name.equals(cs[i].getAttributeValue(ATTR))) {
                return cs[i];
            }
            ++i;
        }
        return null;
    }
}

