/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.project.version;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.project.handlers.AddVersionSupport;
import org.jboss.tools.jst.web.project.version.ProjectVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ProjectVersions {
    protected String descriptorFileName;
    protected long timeStamp;
    protected String path;
    protected File file;
    protected Map<String, ProjectVersion> versions = new TreeMap<String, ProjectVersion>();
    protected String errorMessage = null;
    Document document = null;

    public void setPath(String path) {
        if (this.path != null && this.path.equals(path) && this.file.lastModified() == this.timeStamp) {
            return;
        }
        this.path = path;
        this.file = new File(String.valueOf(path) + this.descriptorFileName);
        this.timeStamp = this.file.isFile() ? this.file.lastModified() : -1L;
        this.update();
    }

    public String getPath() {
        try {
            return new File(this.path).getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            return this.path;
        }
    }

    public void setDescriptorFileName(String fileName) {
        this.descriptorFileName = fileName;
    }

    public void update() {
        this.versions.clear();
        this.errorMessage = null;
        if (!this.file.isFile()) {
            this.errorMessage = NLS.bind((String)WebUIMessages.CANNOT_FIND_PROJECT_VERSIONS_DESCRIPTORFILE, (Object)this.file.getAbsolutePath());
            return;
        }
        Element e = XMLUtil.getElement((File)this.file);
        Document document = this.document = e == null ? null : e.getOwnerDocument();
        if (e == null) {
            try {
                FileReader reader = new FileReader(this.file);
                String[] errors = XMLUtil.getXMLErrors((Reader)reader, (boolean)false);
                this.errorMessage = errors == null || errors.length == 0 ? NLS.bind((String)WebUIMessages.CANNOT_PARSE_PROJECT_VERSIONS_DESCRIPTORFILE, (Object)this.file.getAbsolutePath()) : String.valueOf(NLS.bind((String)WebUIMessages.CANNOT_PARSE_PROJECT_VERSIONS_DESCRIPTORFILE, (Object)this.file.getAbsolutePath())) + ":\n" + errors[0];
            }
            catch (IOException exc) {
                WebModelPlugin.getPluginLog().logError((Throwable)exc);
                this.errorMessage = NLS.bind((String)WebUIMessages.CANNOT_READ_PROJECT_VERSIONS_DESCRIPTORFILE, (Object)this.file.getAbsolutePath());
            }
        } else {
            Element[] vs = XMLUtil.getChildren((Element)e, (String)"version");
            int i = 0;
            while (i < vs.length) {
                this.loadVersion(vs[i]);
                ++i;
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String[] getVersionList() {
        return this.versions.keySet().toArray(new String[0]);
    }

    public ProjectVersion getVersion(String name) {
        return name == null ? null : this.versions.get(name);
    }

    protected ProjectVersion loadVersion(Element e) {
        ProjectVersion version = new ProjectVersion(this);
        version.load(e);
        this.versions.put(version.name, version);
        return version;
    }

    String getAbsoluteLocation(String location) {
        File f = new File(location);
        if (!f.isAbsolute()) {
            f = new File(String.valueOf(this.path) + "/" + location);
        }
        try {
            return f.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
            return f.getAbsolutePath().replace('\\', '/');
        }
    }

    public void save() {
        if (this.document == null) {
            return;
        }
        try {
            XModelObjectLoaderUtil.serialize((Element)this.document.getDocumentElement(), (String)this.file.getAbsolutePath());
        }
        catch (IOException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected abstract String getWizardEntitySuffix();

    public String addVersion() {
        return AddVersionSupport.run(this, "ProjectVersion" + this.getWizardEntitySuffix());
    }

    public void addVersion(Properties p) {
        String common;
        File f;
        Element root = this.document.getDocumentElement();
        String location = p.getProperty("templates location");
        if (location.equals(this.getPath())) {
            location = String.valueOf(location) + "/" + p.getProperty("name");
        }
        if (!(f = new File(location)).isDirectory()) {
            f.mkdirs();
        }
        location = ProjectVersion.getRelativePath(this.path, location);
        Element pe = XMLUtilities.createElement((Element)root, (String)"version");
        pe.setAttribute("displayName", p.getProperty("name"));
        Element tl = XMLUtilities.createElement((Element)pe, (String)"projectTempl");
        tl.setAttribute("location", location);
        ProjectVersion v = this.loadVersion(pe);
        String core = p.getProperty("core library");
        if (core != null && core.length() > 0) {
            v.addLibrary(core, "core");
        }
        if ((common = p.getProperty("common library")) != null && common.length() > 0) {
            v.addLibrary(common, "common");
        }
        this.save();
        this.update();
    }

    public void removeVersion(String name) {
        ProjectVersion v = this.getVersion(name);
        if (v == null || v.element == null) {
            return;
        }
        if (!ProjectVersion.confirm(NLS.bind((String)WebUIMessages.YOU_WANT_TO_DELETE_IMPLEMENTATION, (Object)name))) {
            return;
        }
        v.element.getParentNode().removeChild(v.element);
        this.save();
        this.update();
    }
}

