/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.context;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.impl.SerializingLoader;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.context.AdoptWebProjectContext;
import org.jboss.tools.jst.web.context.ImportWebProjectContext;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;

public abstract class ImportWebDirProjectContext
extends ImportWebProjectContext {
    public static final String PAGE_NAME = "WebPrjAdoptStepName";
    public static final String PAGE_FOLDERS = "WebPrjAdoptStepFolders";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_LOCATON = "web.xml location";
    public static final String ATTR_LINK = "link";
    public static final String ATTR_CLASSES = "classes";
    public static final String ATTR_LIB = "lib";
    public static final String ATTR_ADD_LIB = "add libraries";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_SERVLET_VERSION = "servlet version";
    public static final String ATTR_BUILD = "build";
    public static final String ATTR_MODULE_NAME = "name";
    public static final String ATTR_MODULE_URI = "URI";
    protected String initialName = null;
    protected String initialLocation = null;
    protected String initialLocationErrorMessage = null;
    protected String webXMLErrorMessage = null;

    public ImportWebDirProjectContext(XModelObject target) {
        this.setTarget(target);
        this.initRegistry();
    }

    protected void initRegistry() {
    }

    public void setWebXmlLocation(String location) {
        String sv;
        if (this.isWebXMLUpToDate(location = location.replace('\\', '/'))) {
            return;
        }
        this.webXmlLocation = location;
        this.webXMLTimeStamp = -1L;
        this.initialLocationErrorMessage = null;
        this.webXMLErrorMessage = null;
        this.modules = new XModelObject[0];
        File f = new File(location);
        if (!f.isFile()) {
            this.webXMLErrorMessage = WebUIMessages.FILE_DOESNOT_EXIST;
            return;
        }
        this.webXMLTimeStamp = f.lastModified();
        String body = FileUtil.readFile((File)f);
        String entity = this.getTarget().getModel().getEntityRecognizer().getEntityName(new EntityRecognizerContext("xml", body));
        if (entity == null || !entity.startsWith("FileWebApp")) {
            this.webXMLErrorMessage = WebUIMessages.FILE_ISNOT_RECOGNIZED_AS_WEBDESCRIPTOR_FILE;
            return;
        }
        try {
            this.loadWebXML(body, location);
        }
        catch (XModelException e) {
            this.webXMLErrorMessage = e.getMessage();
            return;
        }
        File webInfFile = f.getParentFile();
        try {
            this.webInfLocation = webInfFile.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            this.webXMLErrorMessage = e.getMessage();
            return;
        }
        boolean w_i = webInfFile.getName().equals("WEB-INF");
        String lib = String.valueOf(this.webInfLocation) + "/lib";
        if (new File(lib).isDirectory()) {
            this.setLibLocation(lib);
        }
        String cls = String.valueOf(this.webInfLocation) + "/classes";
        if (w_i || new File(cls).isDirectory()) {
            this.setClassesLocation(cls);
        }
        this.modules = this.createAdoptContext().createModulesInfo(this.webxml, webInfFile);
        this.createAllModules();
        this.setProjectJavaSrc();
        if (this.webxml != null && (sv = WebAppHelper.getServletVersion(this.webxml)) != null && sv.length() > 0) {
            this.setServletVersion(sv);
        }
    }

    protected void setProjectJavaSrc() {
        String out;
        IProject project = this.getProjectHandle();
        String[] src = EclipseResourceUtil.getJavaProjectSrcLocations((IProject)project);
        this.existingSources = src;
        if (src.length > 0) {
            int i = 0;
            while (i < this.modules.length) {
                if (this.modules[i].getAttributeValue("java src").length() == 0) {
                    this.modules[i].setAttributeValue("java src", src[0]);
                }
                ++i;
            }
        }
        if ((out = EclipseResourceUtil.getJavaProjectOutputLocation((IProject)project)) != null) {
            this.setClassesLocation(out);
        }
    }

    public String getPexFileName() {
        return null;
    }

    public void setPexFileName(String value) {
    }

    @Override
    public String getSuggestedProjectLocation() {
        String webRootPath = this.getWebRootPath();
        File f = new File(webRootPath);
        File fc = f.getParentFile();
        while (fc != null && fc.isDirectory()) {
            if (this.projectName.equals(fc.getName())) {
                return fc.getAbsolutePath();
            }
            fc = fc.getParentFile();
        }
        if (f.getName().equals("WebContent")) {
            return f.getParent();
        }
        return webRootPath;
    }

    public boolean canFinish() {
        if (this.webXmlLocation == null || "".equals(this.webXmlLocation) || this.modules.length <= 0) {
            return false;
        }
        String message = this.getModulesErrorMessage(this.getAllModules(), null);
        if (message == null) {
            message = this.registry.getErrorMessage();
        }
        return message == null;
    }

    public void setAdoptProjectContext(AdoptWebProjectContext context) {
        this.webInfLocation = context.getWebInfLocation();
        this.webXmlLocation = context.getWebXMLLocation();
        this.classesLocation = context.getClassesPath();
        this.libLocation = context.getLibPath();
        this.buildXmlLocation = context.getBuildPath();
        this.modules = context.getModules();
    }

    public void setInitialName(String n) {
        this.initialName = n;
        this.setProjectName(n);
        this.setApplicationName(n);
    }

    public boolean isInitialized() {
        return this.initialName != null;
    }

    public void setInitialLocation(String initialLocation) {
        this.initialLocation = initialLocation;
        if (initialLocation != null) {
            this.setWebXmlLocation(initialLocation);
            this.initialLocationErrorMessage = this.webXMLErrorMessage;
        }
    }

    public String getInitialLocation() {
        return this.initialLocation;
    }

    public String getInitialLocationErrorMessage() {
        return this.initialLocationErrorMessage;
    }

    public String getWebXMLErrorMessage() {
        return this.webXMLErrorMessage;
    }

    protected String getProjectLocation() {
        IProject p = this.getProjectHandle();
        return p == null || p.getLocation() == null ? null : p.getLocation().toString();
    }

    public String getModulesErrorMessage(XModelObject[] modules, XModelObject selected) {
        return null;
    }

    public boolean createConfigFile(String path) {
        return false;
    }

    protected void createConfigFile(File f, String entity) {
        XModelObject c = XModelObjectLoaderUtil.createValidObject((XModel)this.webxml.getModel(), (String)entity);
        String text = ((SerializingLoader)XModelObjectLoaderUtil.getObjectLoader((XModelObject)c)).serializeObject(c);
        FileUtil.writeFile((File)f, (String)text);
        try {
            IProject p = this.getProjectHandle();
            if (p.exists() && p.isAccessible()) {
                p.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            WebModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    @Override
    public abstract String getNatureID();

    protected abstract AdoptWebProjectContext createAdoptContext();

    public abstract void addSupportDelta(Properties var1);

    public abstract void rollbackSupportDelta();

    public abstract void commitSupportDelta();
}

