/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.credentials.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.jboss.tools.foundation.core.credentials.ICredentialDomain;
import org.jboss.tools.foundation.core.credentials.ICredentialListener;
import org.jboss.tools.foundation.core.credentials.ICredentialsModel;
import org.jboss.tools.foundation.core.credentials.ICredentialsPrompter;
import org.jboss.tools.foundation.core.credentials.internal.CredentialDomain;
import org.jboss.tools.foundation.core.internal.FoundationCorePlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CredentialsModel
implements ICredentialsModel {
    private static CredentialsModel instance = new CredentialsModel();
    static final String CREDENTIAL_BASE_KEY = "org.jboss.tools.foundation.core.credentials.CredentialsModel";
    private static final int DOMAIN_ADDED = 1;
    private static final int DOMAIN_REMOVED = 2;
    private static final int CREDENTIAL_ADDED = 3;
    private static final int CREDENTIAL_REMOVED = 4;
    private static final int CREDENTIAL_CHANGED = 5;
    private static final int DEFAULT_CREDENTIAL_CHANGED = 6;
    private IEclipsePreferences prefs;
    private HashMap<String, ICredentialDomain> map;
    private ArrayList<ICredentialListener> listeners;
    private ICredentialsPrompter passwordProvider;
    private static final String CREDENTIAL_PROMPTER_EXT_PT = "org.jboss.tools.foundation.core.credentialPrompter";

    public static CredentialsModel getDefault() {
        return instance;
    }

    public CredentialsModel() {
        this.loadModel();
    }

    private void loadModel() {
        this.map = new HashMap();
        this.listeners = new ArrayList();
        try {
            ICredentialDomain[] domains = this.loadDomainsFromPreferences();
            int i = 0;
            while (i < domains.length) {
                this.map.put(domains[i].getId(), domains[i]);
                ++i;
            }
            if (!this.map.containsKey("access.redhat.com")) {
                this.map.put("access.redhat.com", new CredentialDomain("access.redhat.com", "access.redhat.com", false));
            }
            if (!this.map.containsKey("jboss.org")) {
                this.map.put("jboss.org", new CredentialDomain("jboss.org", "jboss.org", false));
            }
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    private void fireEvent(int type, ICredentialDomain domain, String user) {
        Iterator<ICredentialListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            switch (type) {
                case 1: {
                    it.next().domainAdded(domain);
                    break;
                }
                case 2: {
                    it.next().domainRemoved(domain);
                    break;
                }
                case 3: {
                    it.next().credentialAdded(domain, user);
                    break;
                }
                case 4: {
                    it.next().credentialRemoved(domain, user);
                    break;
                }
                case 5: {
                    it.next().credentialChanged(domain, user);
                    break;
                }
                case 6: {
                    it.next().defaultUsernameChanged(domain, user);
                }
            }
        }
    }

    @Override
    public void addCredentials(ICredentialDomain domain, String user, String pass) {
        this.addCredentials(domain, user, false, pass);
    }

    @Override
    public void addPromptedCredentials(ICredentialDomain domain, String user) {
        this.addCredentials(domain, user, true, null);
    }

    private void addCredentials(ICredentialDomain domain, String user, boolean prompt, String password) {
        CredentialDomain cd = (CredentialDomain)domain;
        boolean existed = cd.userExists(user);
        String preDefault = cd.getDefaultUsername();
        if (!prompt) {
            ((CredentialDomain)domain).addCredentials(user, password);
        } else {
            ((CredentialDomain)domain).addPromptedCredentials(user);
        }
        String postDefault = cd.getDefaultUsername();
        if (!existed) {
            this.fireEvent(3, domain, user);
        } else {
            this.fireEvent(5, domain, user);
        }
        if (!this.isEqual(preDefault, postDefault)) {
            this.fireEvent(6, domain, user);
        }
    }

    @Override
    public boolean credentialRequiresPrompt(ICredentialDomain domain, String user) {
        return ((CredentialDomain)domain).userRequiresPrompt(user);
    }

    @Override
    public void removeCredentials(ICredentialDomain domain, String user) {
        CredentialDomain cd = (CredentialDomain)domain;
        String preDefault = cd.getDefaultUsername();
        ((CredentialDomain)domain).removeCredential(user);
        String postDefault = cd.getDefaultUsername();
        this.fireEvent(4, domain, user);
        if (!this.isEqual(preDefault, postDefault)) {
            this.fireEvent(6, domain, user);
        }
    }

    private boolean isEqual(String one, String two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    @Override
    public ICredentialDomain addDomain(String id, String name, boolean removable) {
        if (!this.map.containsKey(id)) {
            CredentialDomain d = new CredentialDomain(id, name, removable);
            this.map.put(d.getId(), d);
            this.fireEvent(1, d, null);
            return d;
        }
        return null;
    }

    @Override
    public ICredentialDomain[] getDomains() {
        ArrayList<ICredentialDomain> result = new ArrayList<ICredentialDomain>(this.map.values());
        Collections.sort(result, new Comparator<ICredentialDomain>(){

            @Override
            public int compare(ICredentialDomain o1, ICredentialDomain o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result.toArray(new ICredentialDomain[result.size()]);
    }

    @Override
    public ICredentialDomain getDomain(String id) {
        return this.map.get(id);
    }

    @Override
    public void removeDomain(ICredentialDomain domain) {
        if (domain != null && this.map.containsKey(domain.getId())) {
            this.map.remove(domain.getId());
            this.fireEvent(2, domain, null);
        }
    }

    @Override
    public void setDefaultCredential(ICredentialDomain domain, String user) throws IllegalArgumentException {
        String original = ((CredentialDomain)domain).getDefaultUsername();
        if (user != null && !user.equals(original)) {
            ((CredentialDomain)domain).setDefaultUsername(user);
            this.fireEvent(6, domain, user);
        }
    }

    private ICredentialDomain[] loadDomainsFromPreferences() throws BackingStoreException {
        ArrayList<CredentialDomain> domains = new ArrayList<CredentialDomain>();
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode("org.jboss.tools.foundation.core");
        Preferences credentialRoot = root.node(CREDENTIAL_BASE_KEY);
        String[] childNodes = credentialRoot.childrenNames();
        int i = 0;
        while (i < childNodes.length) {
            Preferences domain = credentialRoot.node(childNodes[i]);
            CredentialDomain cd = new CredentialDomain(domain);
            domains.add(cd);
            ++i;
        }
        return domains.toArray(new ICredentialDomain[domains.size()]);
    }

    @Override
    public void saveModel() {
        try {
            ISecurePreferences secureRoot = SecurePreferencesFactory.getDefault();
            ISecurePreferences secureCredentialRoot = secureRoot.node(CREDENTIAL_BASE_KEY);
            IEclipsePreferences root = InstanceScope.INSTANCE.getNode("org.jboss.tools.foundation.core");
            Preferences credentialRoot = root.node(CREDENTIAL_BASE_KEY);
            ArrayList<ICredentialDomain> domains = new ArrayList<ICredentialDomain>(this.map.values());
            for (ICredentialDomain d : domains) {
                ISecurePreferences secureDomainNode = secureCredentialRoot.node(d.getId());
                Preferences domainNode = credentialRoot.node(d.getId());
                ((CredentialDomain)d).saveToPreferences(domainNode, secureDomainNode);
            }
            String[] childrenNodes = credentialRoot.childrenNames();
            int i = 0;
            while (i < childrenNodes.length) {
                if (this.getDomain(childrenNodes[i]) == null) {
                    credentialRoot.node(childrenNodes[i]).removeNode();
                }
                ++i;
            }
            credentialRoot.flush();
            secureCredentialRoot.flush();
        }
        catch (StorageException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (BackingStoreException bse) {
            bse.printStackTrace();
        }
    }

    IEclipsePreferences getPreferences() {
        if (this.prefs == null) {
            this.prefs = ConfigurationScope.INSTANCE.getNode("org.jboss.tools.foundation.core");
        }
        return this.prefs;
    }

    @Override
    public void addCredentialListener(ICredentialListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCredentialListener(ICredentialListener listener) {
        this.listeners.remove(listener);
    }

    String promptForPassword(ICredentialDomain domain, String user) {
        if (this.passwordProvider == null) {
            this.passwordProvider = this.loadPasswordPrompt();
        }
        return this.passwordProvider.getPassword(domain, user);
    }

    private ICredentialsPrompter loadPasswordPrompt() {
        IExtension[] extensions = CredentialsModel.findExtension(CREDENTIAL_PROMPTER_EXT_PT);
        if (extensions.length > 1) {
            FoundationCorePlugin.pluginLog().logError("Multiple credential prompters found for extension point org.jboss.tools.foundation.core.credentialPrompter");
        }
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements.length > 1) {
                    FoundationCorePlugin.pluginLog().logError("Multiple credential prompters found for extension point org.jboss.tools.foundation.core.credentialPrompter");
                }
                try {
                    return (ICredentialsPrompter)elements[j].createExecutableExtension("class");
                }
                catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    FoundationCorePlugin.pluginLog().logError("Unable to load a credential prompter for extension point org.jboss.tools.foundation.core.credentialPrompter");
                }
                catch (CoreException coreException) {
                    FoundationCorePlugin.pluginLog().logError("Unable to load a credential prompter for extension point org.jboss.tools.foundation.core.credentialPrompter");
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }
}

