/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkPartitionerBuilder;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkPartitionerDefinition;
import org.jboss.tools.common.text.ext.hyperlink.IExclusiblePartitionerRecognition;
import org.jboss.tools.common.text.ext.hyperlink.IHyperLinkPartitionPriority;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractHyperlinkPartitioner
implements IHyperlinkPartitioner {
    @Override
    public IHyperlinkRegion getChildPartitionRegion(IDocument document, int offset, IHyperlinkRegion superRegion) {
        IHyperlinkPartitioner partitioner;
        IHyperlinkRegion childRegion = this.parse(document, offset, superRegion);
        if (childRegion == null) {
            return null;
        }
        HyperlinkPartitionerDefinition[] hyperlinkPartitionerDefinitions = HyperlinkPartitionerBuilder.getInstance().getHyperlinkPartitionerDefinitions(childRegion.getContentType(), childRegion.getType(), childRegion.getAxis());
        ArrayList<IHyperlinkPartitioner> partitioners = new ArrayList<IHyperlinkPartitioner>();
        int i = 0;
        while (i < hyperlinkPartitionerDefinitions.length) {
            HyperlinkPartitionerDefinition def = hyperlinkPartitionerDefinitions[i];
            partitioner = def.createHyperlinkPartitioner();
            if (partitioner != null) {
                partitioners.add(partitioner);
            }
            ++i;
        }
        IHyperlinkPartitioner[] sortedPartitioners = this.orderHyperlinkPartitioners(partitioners.toArray(new IHyperlinkPartitioner[0]));
        int i2 = 0;
        while (sortedPartitioners != null && i2 < sortedPartitioners.length) {
            partitioner = sortedPartitioners[i2];
            if (!(partitioner instanceof IHyperlinkPartitionRecognizer) || ((IHyperlinkPartitionRecognizer)((Object)partitioner)).recognize(document, offset, childRegion)) {
                IExclusiblePartitionerRecognition epr;
                IHyperlinkPartitioner replacement;
                if (partitioner instanceof IExclusiblePartitionerRecognition && (replacement = this.findExclusionPartitioner((epr = (IExclusiblePartitionerRecognition)((Object)partitioner)).getExclusionPartitionType(), hyperlinkPartitionerDefinitions, document, offset, childRegion)) != null) {
                    return replacement.getChildPartitionRegion(document, offset, childRegion);
                }
                return partitioner.getChildPartitionRegion(document, offset, childRegion);
            }
            ++i2;
        }
        return childRegion;
    }

    protected Sorter createSorter() {
        return new Sorter(){

            public boolean compare(Object partitioner1, Object partitioner2) {
                IHyperlinkPartitioner p1 = (IHyperlinkPartitioner)partitioner1;
                IHyperlinkPartitioner p2 = (IHyperlinkPartitioner)partitioner2;
                String s1 = ((IHyperlinkPartitioner)partitioner1).getClass().getName();
                String s2 = ((IHyperlinkPartitioner)partitioner2).getClass().getName();
                int pp1 = Integer.MAX_VALUE;
                int pp2 = Integer.MAX_VALUE;
                if (p1 instanceof IHyperLinkPartitionPriority) {
                    pp1 = ((IHyperLinkPartitionPriority)((Object)p1)).getPriority();
                }
                if (p2 instanceof IHyperLinkPartitionPriority) {
                    pp2 = ((IHyperLinkPartitionPriority)((Object)p2)).getPriority();
                }
                if (pp1 == pp2) {
                    return s2.compareTo(s1) > 0;
                }
                return pp1 < pp2;
            }
        };
    }

    protected IHyperlinkPartitioner[] orderHyperlinkPartitioners(IHyperlinkPartitioner[] partitioners) {
        Object[] sorted = this.createSorter().sort((Object[])partitioners);
        IHyperlinkPartitioner[] sortedPartitioners = new IHyperlinkPartitioner[sorted.length];
        System.arraycopy(sorted, 0, sortedPartitioners, 0, sorted.length);
        return sortedPartitioners;
    }

    IHyperlinkPartitioner findExclusionPartitioner(String partitionType, HyperlinkPartitionerDefinition[] hyperlinkPartitionerDefinitions, IDocument document, int offset, IHyperlinkRegion region) {
        int i = 0;
        while (i < hyperlinkPartitionerDefinitions.length) {
            HyperlinkPartitionerDefinition def = hyperlinkPartitionerDefinitions[i];
            IHyperlinkPartitioner partitioner = def.createHyperlinkPartitioner();
            if (partitioner instanceof IExclusiblePartitionerRecognition && ((IExclusiblePartitionerRecognition)((Object)partitioner)).excludes(partitionType, document, offset, region)) {
                return partitioner;
            }
            ++i;
        }
        return null;
    }

    protected static IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    protected abstract IHyperlinkRegion parse(IDocument var1, int var2, IHyperlinkRegion var3);

    protected String getAxis(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node node = Utils.findNodeForOffset(xmlDocument, offset);
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                String string = String.valueOf(Utils.getParentAxisForNode(xmlDocument, attr)) + attr.getName() + "/";
                return string;
            }
            String string = Utils.getParentAxisForNode(xmlDocument, node);
            return string;
        }
        finally {
            smw.dispose();
        }
    }
}

