/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.discovery.core.internal.connectors.xpl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.IDynamicExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.Directory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class DiscoveryRegistryStrategy
extends RegistryStrategy {
    private final List<JarFile> jars = new ArrayList<JarFile>();
    private final Map<String, File> contributorToJarFile = new HashMap<String, File>();
    private final Map<String, Directory.Entry> contributorToDirectoryEntry = new HashMap<String, Directory.Entry>();
    private final Object token;
    private Map<File, Directory.Entry> bundleFileToDirectoryEntry;
    private String[] bundleIds;

    public DiscoveryRegistryStrategy(File[] storageDirs, boolean[] cacheReadOnly, Object token) {
        super(storageDirs, cacheReadOnly);
        this.token = token;
    }

    public void onStart(IExtensionRegistry registry, boolean loadedFromCache) {
        super.onStart(registry, loadedFromCache);
        loadedFromCache = false;
        if (!loadedFromCache) {
            String[] stringArray = this.getExtensionPointProviderBundleIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String bundleId = stringArray[n2];
                this.processExtensionPointProviderBundle(registry, bundleId);
                ++n2;
            }
            this.processBundles(registry);
        }
    }

    public boolean debug() {
        return false;
    }

    public void setExtensionPointProviderBundleIds(String ... bundleIds) {
        this.bundleIds = bundleIds;
    }

    public String[] getExtensionPointProviderBundleIds() {
        if (this.bundleIds == null) {
            this.bundleIds = new String[]{"org.eclipse.mylyn.discovery.core"};
        }
        return this.bundleIds;
    }

    private void processExtensionPointProviderBundle(IExtensionRegistry registry, String bundleId) {
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"Cannot load bundle {0}", (Object)bundleId)));
                return;
            }
            RegistryContributor contributor = new RegistryContributor(bundle.getSymbolicName(), bundle.getSymbolicName(), null, null);
            try (InputStream inputStream = bundle.getEntry("plugin.xml").openStream();){
                registry.addContribution(inputStream, (IContributor)contributor, false, bundle.getSymbolicName(), null, this.token);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    private void processBundles(IExtensionRegistry registry) {
        if (this.bundleFileToDirectoryEntry == null) {
            throw new IllegalStateException();
        }
        for (Map.Entry<File, Directory.Entry> bundleFile : this.bundleFileToDirectoryEntry.entrySet()) {
            try {
                this.processBundle(registry, bundleFile.getValue(), bundleFile.getKey());
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.discovery.core", NLS.bind((String)"Cannot load bundle {0} from url {1}: {2}", (Object[])new Object[]{bundleFile.getKey().getName(), bundleFile.getValue().getLocation(), e.getMessage()}), (Throwable)e));
            }
        }
    }

    private void processBundle(IExtensionRegistry registry, Directory.Entry entry, File bundleFile) throws IOException {
        JarFile jarFile = new JarFile(bundleFile);
        this.jars.add(jarFile);
        ZipEntry pluginXmlEntry = jarFile.getEntry("plugin.xml");
        if (pluginXmlEntry == null) {
            throw new IOException("no plugin.xml in bundle");
        }
        RegistryContributor contributor = new RegistryContributor(bundleFile.getName(), bundleFile.getName(), null, null);
        if (((IDynamicExtensionRegistry)registry).hasContributor((IContributor)contributor)) {
            jarFile.close();
            return;
        }
        this.contributorToJarFile.put(contributor.getName(), bundleFile);
        this.contributorToDirectoryEntry.put(contributor.getName(), entry);
        ResourceBundle translationBundle = this.loadTranslationBundle(jarFile);
        try (InputStream inputStream = jarFile.getInputStream(pluginXmlEntry);){
            registry.addContribution(inputStream, (IContributor)contributor, false, bundleFile.getPath(), translationBundle, this.token);
        }
    }

    private ResourceBundle loadTranslationBundle(JarFile jarFile) throws IOException {
        List<String> bundleNames = this.computeBundleNames("plugin");
        for (String bundleName : bundleNames) {
            ZipEntry entry = jarFile.getEntry(bundleName);
            if (entry == null) continue;
            try (InputStream inputStream = jarFile.getInputStream(entry);){
                PropertyResourceBundle resourceBundle;
                PropertyResourceBundle propertyResourceBundle = resourceBundle = new PropertyResourceBundle(inputStream);
                return propertyResourceBundle;
            }
        }
        return null;
    }

    private List<String> computeBundleNames(String baseName) {
        String suffix = ".properties";
        String name = baseName;
        ArrayList<String> bundleNames = new ArrayList<String>();
        Locale locale = Locale.getDefault();
        bundleNames.add(String.valueOf(name) + suffix);
        if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            name = String.valueOf(name) + '_' + locale.getLanguage();
            bundleNames.add(0, String.valueOf(name) + suffix);
        }
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            name = String.valueOf(name) + '_' + locale.getCountry();
            bundleNames.add(0, String.valueOf(name) + suffix);
        }
        if (locale.getVariant() != null && locale.getVariant().length() > 0) {
            name = String.valueOf(name) + '_' + locale.getVariant();
            bundleNames.add(0, String.valueOf(name) + suffix);
        }
        return bundleNames;
    }

    /*
     * Unable to fully structure code
     */
    public void onStop(IExtensionRegistry registry) {
        try {
            super.onStop(registry);
        }
        finally {
            ** for (jar : this.jars)
        }
lbl-1000:
        // 1 sources

        {
            try {
                jar.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl11:
        // 1 sources

        this.jars.clear();
    }

    public File getJarFile(IContributor contributor) {
        File file = this.contributorToJarFile.get(contributor.getName());
        if (file == null) {
            throw new IllegalArgumentException(contributor.getName());
        }
        return file;
    }

    public Directory.Entry getDirectoryEntry(IContributor contributor) {
        Directory.Entry entry = this.contributorToDirectoryEntry.get(contributor.getName());
        if (entry == null) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} is not a known contributor in the discovery registry", (Object)contributor.getName()));
        }
        return entry;
    }

    public void setBundles(Map<File, Directory.Entry> bundleFileToDirectoryEntry) {
        this.bundleFileToDirectoryEntry = bundleFileToDirectoryEntry;
    }
}

