/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.project.examples.fixes.IProjectExamplesFix;
import org.jboss.tools.project.examples.fixes.ProjectFixManager;
import org.jboss.tools.project.examples.fixes.UIHandler;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;
import org.jboss.tools.project.examples.wizard.WizardContext;

public class NewProjectExamplesRequirementsPage
extends WizardPage
implements IProjectExamplesWizardPage {
    private static final String PAGE_NAME = "org.jboss.tools.project.examples.requirements";
    protected ProjectExampleWorkingCopy projectExample;
    protected Text descriptionText;
    protected Label projectSizeLabel;
    protected Text projectSize;
    protected WizardContext wizardContext;
    protected TableViewer tableViewer;
    protected List<IProjectExamplesFix> fixes = new ArrayList<IProjectExamplesFix>();
    private Image fulfilledRequirement;
    private Image missingRecommendation;
    private Image missingRequirement;
    private Link link;
    private IServerLifecycleListener serverListener = new IServerLifecycleListener(){

        private void refreshInUIThread() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NewProjectExamplesRequirementsPage.this.refreshFixes();
                }
            });
        }

        public void serverAdded(IServer server) {
            this.refreshInUIThread();
        }

        public void serverChanged(IServer server) {
            this.refreshInUIThread();
        }

        public void serverRemoved(IServer server) {
            this.refreshInUIThread();
        }
    };
    protected ProjectFixManager fixManager;
    private Composite sizeComposite;

    public NewProjectExamplesRequirementsPage(ProjectExampleWorkingCopy projectExample) {
        this(PAGE_NAME, projectExample);
    }

    public NewProjectExamplesRequirementsPage(String pageName, ProjectExampleWorkingCopy projectExample) {
        super(pageName);
        this.projectExample = projectExample;
        this.setTitleAndDescription(projectExample);
        this.fulfilledRequirement = ProjectExamplesActivator.getImageDescriptor("icons/ok.png").createImage();
        this.missingRecommendation = ProjectExamplesActivator.getImageDescriptor("icons/warning.gif").createImage();
        this.missingRequirement = ProjectExamplesActivator.getImageDescriptor("icons/error.gif").createImage();
        this.fixManager = ProjectExamplesActivator.getDefault().getProjectFixManager();
    }

    public NewProjectExamplesRequirementsPage() {
        this(null);
    }

    protected void setTitleAndDescription(ProjectExample projectExample) {
        this.setTitle("Requirements and Recommendations");
        this.setDescription("Project Example Requirements");
        boolean showSize = false;
        if (projectExample != null) {
            if (projectExample.getShortDescription() != null) {
                this.setTitle(projectExample.getShortDescription());
            }
            if (projectExample.getHeadLine() != null) {
                this.setDescription(ProjectExamplesActivator.getShortDescription(projectExample.getHeadLine()));
            }
            if (this.descriptionText != null) {
                if (projectExample.getDescription() != null) {
                    this.descriptionText.setText(projectExample.getDescription());
                }
                if (this.projectSize != null && projectExample.getSize() > 0L) {
                    showSize = true;
                    this.projectSize.setText(projectExample.getSizeAsText());
                }
            }
        } else if (this.descriptionText != null) {
            this.descriptionText.setText("");
            if (this.projectSize != null) {
                this.projectSize.setText("");
            }
        }
        if (this.sizeComposite != null) {
            GridData data = (GridData)this.sizeComposite.getLayoutData();
            data.exclude = !showSize;
            this.sizeComposite.setVisible(showSize);
            this.sizeComposite.getParent().pack();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, false, false);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setDescriptionArea(composite);
        this.setSelectionArea(composite);
        Group fixesGroup = new Group(composite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        fixesGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        fixesGroup.setLayout((Layout)layout);
        fixesGroup.setText("Requirements and Recommendations");
        this.tableViewer = new TableViewer((Composite)fixesGroup, 68356);
        Table table = this.tableViewer.getTable();
        gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{"Type", "Description", "Status"};
        int[] columnWidths = new int[]{100, 300, 50};
        int i = 0;
        while (i < columnNames.length) {
            TableViewerColumn tc = new TableViewerColumn(this.tableViewer, 16384);
            tc.getColumn().setText(columnNames[i]);
            tc.getColumn().setWidth(columnWidths[i]);
            tc.setLabelProvider((CellLabelProvider)new FixLabelProvider(i));
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)new FixContentProvider(this.fixes));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.createButtons((Composite)fixesGroup, this.tableViewer);
        this.link = new Link(composite, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.link.setLayoutData((Object)gd);
        this.setAdditionalControls(composite);
        this.setPageComplete(true);
        this.setControl((Control)composite);
        if (this.projectExample != null) {
            this.setProjectExample(this.projectExample);
        }
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverListener);
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverListener);
        super.dispose();
    }

    protected void setDescriptionArea(Composite composite) {
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.NewProjectExamplesWizardPage_Description);
        GridData gd = new GridData(1, 4, false, false);
        gd.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = new Text(composite, 2888);
        gd = new GridData(4, 4, false, false);
        GC gc = new GC((Drawable)composite.getParent());
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)6);
        gc.dispose();
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.descriptionText.setLayoutData((Object)gd);
    }

    protected void setSelectionArea(Composite composite) {
        this.sizeComposite = new Composite(composite, 0);
        this.sizeComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 4, true, true);
        this.sizeComposite.setLayoutData((Object)data);
        this.projectSizeLabel = new Label(this.sizeComposite, 0);
        this.projectSizeLabel.setText(Messages.NewProjectExamplesWizardPage_Project_size);
        this.projectSize = new Text(this.sizeComposite, 8);
        this.projectSize.setLayoutData((Object)new GridData(768));
        Label filler = new Label(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 2).applyTo((Control)filler);
    }

    protected void setAdditionalControls(Composite composite) {
    }

    private void createButtons(Composite parent, TableViewer viewer) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        final Button install = new Button(buttonComposite, 8);
        install.setLayoutData((Object)new GridData(768));
        install.setText("Install...");
        install.setEnabled(false);
        install.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProjectExamplesFix fix = NewProjectExamplesRequirementsPage.this.getSelectedProjectFix();
                if (fix != null) {
                    UIHandler uiHandler = NewProjectExamplesRequirementsPage.this.getUIHandler(fix);
                    uiHandler.handleInstallRequest(NewProjectExamplesRequirementsPage.this.getShell(), (IRunnableContext)NewProjectExamplesRequirementsPage.this.getContainer(), fix);
                    NewProjectExamplesRequirementsPage.this.refreshFixes();
                }
            }
        });
        final Button downloadAndInstall = new Button(buttonComposite, 8);
        downloadAndInstall.setLayoutData((Object)new GridData(768));
        downloadAndInstall.setText("Download and Install...");
        downloadAndInstall.setEnabled(false);
        downloadAndInstall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final IProjectExamplesFix fix = NewProjectExamplesRequirementsPage.this.getSelectedProjectFix();
                if (fix == null) {
                    return;
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UIHandler uiHandler = (this).NewProjectExamplesRequirementsPage.this.fixManager.getUIHandler(fix);
                        uiHandler.handleDownloadRequest(Display.getCurrent().getActiveShell(), (IRunnableContext)NewProjectExamplesRequirementsPage.this.getContainer(), fix);
                        NewProjectExamplesRequirementsPage.this.refreshFixes();
                    }
                });
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                final IProjectExamplesFix fix = NewProjectExamplesRequirementsPage.this.getSelectedProjectFix();
                if (fix == null) {
                    return;
                }
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        UIHandler uiHandler = NewProjectExamplesRequirementsPage.this.getUIHandler(fix);
                        uiHandler.decorateInstallButton(install, fix, (IProgressMonitor)monitor);
                        uiHandler.decorateDownloadButton(downloadAndInstall, fix, (IProgressMonitor)monitor);
                    }
                });
            }
        });
    }

    protected IProjectExamplesFix getSelectedProjectFix() {
        IStructuredSelection selection;
        Object object;
        ISelection sel = this.tableViewer.getSelection();
        if (sel instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof IProjectExamplesFix) {
            return (IProjectExamplesFix)object;
        }
        return null;
    }

    public ProjectExample getProjectExample() {
        return this.projectExample;
    }

    @Override
    public void setProjectExample(final ProjectExampleWorkingCopy projectExample) {
        this.projectExample = projectExample;
        this.setTitleAndDescription(projectExample);
        this.refreshFixes();
        if (this.link == null) {
            return;
        }
        if (projectExample != null && projectExample.getSourceLocation() != null && !projectExample.getSourceLocation().isEmpty()) {
            this.link.setVisible(true);
            this.link.setText("Found a bug? Or have improvements to this example? Help us develop it, source can be found at <a>Project Example Source</a>");
            this.link.getParent().pack(true);
            this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text = e.text;
                    if ("Project Example Source".equals(text)) {
                        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                        try {
                            URL url = new URL(projectExample.getSourceLocation());
                            support.getExternalBrowser().openURL(url);
                        }
                        catch (Exception e1) {
                            ProjectExamplesActivator.log(e1);
                        }
                    }
                }
            });
        } else {
            this.link.setVisible(false);
            this.link.setText("");
            this.link.getParent().pack(true);
        }
    }

    protected void refreshFixes() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        this.fixes.clear();
        if (this.projectExample != null) {
            this.fixes.addAll(this.projectExample.getFixes());
        }
        this.tableViewer.setInput(this.fixes);
        this.validate();
    }

    protected UIHandler getUIHandler(IProjectExamplesFix fix) {
        return this.fixManager.getUIHandler(fix);
    }

    public void setDescriptionText(String longDescription) {
        if (this.descriptionText != null) {
            if (longDescription == null) {
                longDescription = "";
            }
            if (!longDescription.equals(this.descriptionText.getText())) {
                this.descriptionText.setText(longDescription);
            }
        }
    }

    public IWizardPage getNextPage() {
        IWizard wizard;
        if (this.projectExample != null && (wizard = this.getWizard()) instanceof NewProjectExamplesWizard2) {
            NewProjectExamplesWizard2 exampleWizard = (NewProjectExamplesWizard2)wizard;
            ProjectExample projectExample = exampleWizard.getSelectedProjectExample();
            if (projectExample != null && projectExample.getImportType() != null) {
                for (IProjectExamplesWizardPage page : exampleWizard.getContributedPages("extra")) {
                    if (!projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                    return page;
                }
            }
            return ((NewProjectExamplesWizard2)wizard).getLocationsPage();
        }
        return super.getNextPage();
    }

    @Override
    public void onWizardContextChange(String key, Object value) {
    }

    @Override
    public boolean finishPage() {
        return true;
    }

    @Override
    public String getProjectExampleType() {
        return "zip";
    }

    @Override
    public Map<String, Object> getPropertiesMap() {
        return null;
    }

    @Override
    public void setWizardContext(WizardContext context) {
        this.wizardContext = context;
    }

    @Override
    public String getPageType() {
        return "requirement";
    }

    protected void validate() {
        if (this.fixes != null && !this.fixes.isEmpty()) {
            for (IProjectExamplesFix fix : this.fixes) {
                if (!this.isBlocking(fix)) continue;
                this.setErrorMessage("Some requirements must be installed in order to proceed");
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private boolean isBlocking(IProjectExamplesFix fix) {
        return fix != null && fix.isRequired() && !fix.isSatisfied();
    }

    private class FixContentProvider
    implements IStructuredContentProvider {
        private List<IProjectExamplesFix> fixes;

        public FixContentProvider(List<IProjectExamplesFix> fixes) {
            this.fixes = fixes;
        }

        public Object[] getElements(Object inputElement) {
            return this.fixes.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fixes = (List)newInput;
        }
    }

    private class FixLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        public FixLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            Image image = null;
            if (this.columnIndex == 2 && element instanceof IProjectExamplesFix) {
                IProjectExamplesFix fix = (IProjectExamplesFix)element;
                image = fix.isSatisfied() ? NewProjectExamplesRequirementsPage.this.fulfilledRequirement : (fix.isRequired() ? NewProjectExamplesRequirementsPage.this.missingRequirement : NewProjectExamplesRequirementsPage.this.missingRecommendation);
            }
            return image;
        }

        public String getText(Object element) {
            if (element instanceof IProjectExamplesFix) {
                IProjectExamplesFix fix = (IProjectExamplesFix)element;
                if (this.columnIndex == 0) {
                    return fix.getLabel();
                }
                if (this.columnIndex == 1) {
                    return fix.getDescription();
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            IProjectExamplesFix fix;
            if (element instanceof IProjectExamplesFix && NewProjectExamplesRequirementsPage.this.isBlocking(fix = (IProjectExamplesFix)element)) {
                return Display.getCurrent().getSystemColor(3);
            }
            return super.getForeground(element);
        }

        public String getToolTipText(Object element) {
            if ("win32".equals(Platform.getOS())) {
                return null;
            }
            String tooltip = null;
            if (element instanceof IProjectExamplesFix) {
                IProjectExamplesFix fix = (IProjectExamplesFix)element;
                if (this.columnIndex == 1) {
                    tooltip = fix.getDescription();
                } else if (this.columnIndex == 2) {
                    String label = fix.getLabel();
                    if (fix.isSatisfied()) {
                        String type = fix.isRequired() ? "required" : "recommended";
                        tooltip = NLS.bind((String)"This {0} {1} is already installed.", (Object)type, (Object)label);
                    } else {
                        tooltip = fix.isRequired() ? NLS.bind((String)"This {0} must be installed to in order to continue.", (Object)label) : NLS.bind((String)"Installing this {0} is recommended but not mandatory.", (Object)label);
                    }
                }
            }
            return tooltip;
        }
    }
}

