/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.tools.project.examples.IProjectExampleManager;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.model.IImportProjectExample;
import org.jboss.tools.project.examples.model.IProjectExampleSite;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleCategory;
import org.jboss.tools.project.examples.model.ProjectExampleUtil;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.runtimes.RuntimeUtils;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;
import org.jboss.tools.project.examples.wizard.ProjectExamplesPatternFilter;
import org.jboss.tools.project.examples.wizard.RuntimeTypeFilter;
import org.jboss.tools.project.examples.wizard.SiteFilter;

public class NewProjectExamplesMainPage
extends WizardPage {
    private static final int DEFAULT_WIDTH = 600;
    private IStructuredSelection selection;
    private Combo siteCombo;
    private List<ProjectExampleCategory> categories;
    private Text descriptionText;
    private ProjectExampleWorkingCopy selectedProject;
    private Combo targetRuntimeTypesCombo;

    public NewProjectExamplesMainPage() {
        super("org.jboss.tools.project.examples.main");
        this.setTitle(Messages.NewProjectExamplesWizardPage_Project_Example);
        this.setDescription(Messages.NewProjectExamplesWizardPage_Import_Project_Example);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, false, false);
        composite.setLayoutData((Object)gd);
        Composite siteComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        siteComposite.setLayout((Layout)gridLayout);
        gd = new GridData(4, 1, false, false);
        siteComposite.setLayoutData((Object)gd);
        final Button button = new Button(siteComposite, 32);
        gd = new GridData(4, 1, false, false);
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        button.setText(Messages.ProjectExamplesPreferencePage_Show_experimental_sites);
        IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
        button.setSelection(store.getBoolean("showExperimentalSites"));
        final Button serverButton = new Button(siteComposite, 32);
        gd = new GridData(4, 1, false, false);
        gd.horizontalSpan = 2;
        serverButton.setLayoutData((Object)gd);
        serverButton.setText(Messages.ProjectExamplesPreferencePage_Show_runtime_sites);
        serverButton.setSelection(store.getBoolean("showRuntimeSites"));
        new Label(siteComposite, 0).setText(Messages.NewProjectExamplesWizardPage_Site);
        this.siteCombo = new Combo(siteComposite, 8);
        this.siteCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(siteComposite, 0).setText(Messages.NewProjectExamplesMainPage_TargetedRuntime);
        this.targetRuntimeTypesCombo = new Combo(siteComposite, 8);
        this.targetRuntimeTypesCombo.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(composite, 0).setText(Messages.NewProjectExamplesWizardPage_Projects);
        ProjectExamplesPatternFilter filter = new ProjectExamplesPatternFilter();
        int styleBits = 2884;
        FilteredTree filteredTree = new FilteredTree(composite, styleBits, (PatternFilter)filter, true);
        filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        final TreeViewer viewer = filteredTree.getViewer();
        Tree tree = viewer.getTree();
        gd = new GridData(4, 4, true, true);
        GC gc = new GC((Drawable)parent);
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)9);
        gc.dispose();
        tree.setLayoutData((Object)gd);
        tree.setFont(parent.getFont());
        viewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        viewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        final SiteFilter siteFilter = new SiteFilter();
        final RuntimeTypeFilter serverFilter = new RuntimeTypeFilter();
        viewer.addFilter((ViewerFilter)siteFilter);
        viewer.addFilter((ViewerFilter)serverFilter);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.NewProjectExamplesWizardPage_Description);
        this.descriptionText = new Text(composite, 2888);
        gd = new GridData(4, 4, true, true);
        gc = new GC((Drawable)parent);
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)6);
        gc.dispose();
        this.descriptionText.setLayoutData((Object)gd);
        Composite internal = new Composite(composite, 0);
        internal.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(4, 4, true, false);
        gd.widthHint = 600;
        internal.setLayoutData((Object)gd);
        Label projectNameLabel = new Label(internal, 0);
        projectNameLabel.setText(Messages.NewProjectExamplesWizardPage_Project_name);
        final Text projectName = new Text(internal, 2056);
        projectName.setLayoutData((Object)new GridData(768));
        Label projectSizeLabel = new Label(internal, 0);
        projectSizeLabel.setText(Messages.NewProjectExamplesWizardPage_Project_size);
        final Text projectSize = new Text(internal, 2056);
        projectSize.setLayoutData((Object)new GridData(768));
        Label projectURLLabel = new Label(internal, 0);
        projectURLLabel.setText(Messages.NewProjectExamplesWizardPage_URL);
        final Text projectURL = new Text(internal, 2056);
        projectURL.setLayoutData((Object)new GridData(768));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewProjectExamplesMainPage.this.selection = (IStructuredSelection)event.getSelection();
                Object selected = NewProjectExamplesMainPage.this.selection.getFirstElement();
                String projectType = null;
                if (selected instanceof ProjectExample && NewProjectExamplesMainPage.this.selection.size() == 1) {
                    NewProjectExamplesMainPage.this.selectedProject = ProjectExamplesActivator.getDefault().getProjectExampleManager().createWorkingCopy((ProjectExample)selected);
                    NewProjectExamplesMainPage.this.descriptionText.setText(NewProjectExamplesMainPage.this.selectedProject.getDescription());
                    projectName.setText(NewProjectExamplesMainPage.this.selectedProject.getName());
                    projectURL.setText(NewProjectExamplesMainPage.this.selectedProject.getUrl());
                    if (NewProjectExamplesMainPage.this.selectedProject.getSize() > 0L) {
                        projectSize.setEnabled(true);
                        projectSize.setText(NewProjectExamplesMainPage.this.selectedProject.getSizeAsText());
                    } else {
                        projectSize.setEnabled(false);
                        projectSize.setText("");
                    }
                    projectType = NewProjectExamplesMainPage.this.selectedProject.getImportType();
                } else {
                    ProjectExampleCategory category;
                    NewProjectExamplesMainPage.this.selectedProject = null;
                    String description = "";
                    if (selected instanceof ProjectExampleCategory && (category = (ProjectExampleCategory)selected).getDescription() != null) {
                        description = category.getDescription();
                    }
                    NewProjectExamplesMainPage.this.descriptionText.setText(description);
                    projectName.setText("");
                    projectURL.setText("");
                    projectSize.setText("");
                }
                IWizardPage[] iWizardPageArray = NewProjectExamplesMainPage.this.getWizard().getPages();
                int n = iWizardPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray[n2];
                    if (page instanceof IProjectExamplesWizardPage) {
                        IProjectExamplesWizardPage pewp = (IProjectExamplesWizardPage)page;
                        if (projectType != null && projectType.equals(pewp.getProjectExampleType())) {
                            pewp.setProjectExample(NewProjectExamplesMainPage.this.selectedProject);
                        } else {
                            pewp.setProjectExample(null);
                        }
                    }
                    ++n2;
                }
                boolean canFinish = NewProjectExamplesMainPage.this.refresh(false);
                NewProjectExamplesMainPage.this.setPageComplete(canFinish);
            }
        });
        this.siteCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                siteFilter.setSite(NewProjectExamplesMainPage.this.siteCombo.getText());
                viewer.refresh();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
                store.setValue("showExperimentalSites", button.getSelection());
                String selectedRuntime = NewProjectExamplesMainPage.this.targetRuntimeTypesCombo.getText();
                String selectedSite = NewProjectExamplesMainPage.this.siteCombo.getText();
                NewProjectExamplesMainPage.this.refresh(viewer, true);
                NewProjectExamplesMainPage.restoreCombo(NewProjectExamplesMainPage.this.targetRuntimeTypesCombo, selectedRuntime);
                NewProjectExamplesMainPage.restoreCombo(NewProjectExamplesMainPage.this.siteCombo, selectedSite);
                siteFilter.setSite(NewProjectExamplesMainPage.this.siteCombo.getText());
                viewer.refresh();
            }
        });
        serverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPreferenceStore store = ProjectExamplesActivator.getDefault().getPreferenceStore();
                store.setValue("showRuntimeSites", serverButton.getSelection());
                String selectedRuntime = NewProjectExamplesMainPage.this.targetRuntimeTypesCombo.getText();
                String selectedSite = NewProjectExamplesMainPage.this.siteCombo.getText();
                NewProjectExamplesMainPage.this.refresh(viewer, true);
                NewProjectExamplesMainPage.restoreCombo(NewProjectExamplesMainPage.this.targetRuntimeTypesCombo, selectedRuntime);
                NewProjectExamplesMainPage.restoreCombo(NewProjectExamplesMainPage.this.siteCombo, selectedSite);
                siteFilter.setSite(NewProjectExamplesMainPage.this.siteCombo.getText());
                viewer.refresh();
            }
        });
        this.targetRuntimeTypesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                serverFilter.setRuntimeType(NewProjectExamplesMainPage.this.targetRuntimeTypesCombo.getText());
                viewer.refresh();
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)composite);
        this.refresh(viewer, true);
        this.siteCombo.setText(ProjectExamplesActivator.ALL_SITES);
        this.targetRuntimeTypesCombo.setText(ProjectExamplesActivator.ALL_RUNTIMES);
    }

    private void loadRuntimeTypes() {
        if (this.targetRuntimeTypesCombo == null) {
            return;
        }
        this.targetRuntimeTypesCombo.removeAll();
        this.targetRuntimeTypesCombo.add(ProjectExamplesActivator.ALL_RUNTIMES);
        Set<IRuntimeType> installedRuntimeTypes = RuntimeUtils.getInstalledRuntimeTypes();
        ArrayList<IRuntimeType> sortedTypes = new ArrayList<IRuntimeType>();
        for (ProjectExampleCategory category : this.categories) {
            for (ProjectExample project : category.getProjects()) {
                for (IRuntimeType type : WTPRuntimeFix.getTargetedServerRuntimes(project)) {
                    if (sortedTypes.contains(type)) continue;
                    if (installedRuntimeTypes.contains(type)) {
                        sortedTypes.add(0, type);
                        continue;
                    }
                    sortedTypes.add(type);
                }
            }
        }
        for (IRuntimeType type : sortedTypes) {
            this.targetRuntimeTypesCombo.add(type.getName());
        }
    }

    private void refresh(TreeViewer viewer, boolean show) {
        AdaptableList input = new AdaptableList(this.getCategories(show));
        viewer.setInput((Object)input);
        viewer.refresh();
        String[] items = this.getItems();
        this.siteCombo.setItems(items);
        this.loadRuntimeTypes();
    }

    private List<ProjectExampleCategory> getCategories(boolean show) {
        final ArrayList<ProjectExampleCategory> nonEmptyCategories = new ArrayList<ProjectExampleCategory>();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IProjectExampleManager manager = ProjectExamplesActivator.getDefault().getProjectExampleManager();
                try {
                    Collection<ProjectExampleCategory> rawCategories = manager.getCategorizedExamples(monitor);
                    for (ProjectExampleCategory c : rawCategories) {
                        if (c.getProjects().isEmpty()) continue;
                        nonEmptyCategories.add(c);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
        }
        catch (Exception e) {
            ProjectExamplesActivator.log(e);
        }
        HashSet<IProjectExampleSite> invalidSites = ProjectExampleUtil.getInvalidSites();
        boolean showInvalidSites = ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("invalidSites");
        if (invalidSites.size() > 0 && showInvalidSites && show) {
            StringBuilder message = new StringBuilder(Messages.NewProjectExamplesWizardPage_Cannot_access_the_following_sites);
            for (IProjectExampleSite site : invalidSites) {
                message.append(site.getName());
                message.append("\n");
                ProjectExamplesActivator.log(NLS.bind((String)Messages.InvalideSite, (Object[])new Object[]{site.getName(), site.getUrl()}));
            }
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)Messages.NewProjectExamplesWizardPage_Invalid_Sites, (String)message.toString(), (String)Messages.NewProjectExamplesWizardPage_Show_this_dialog_next_time, (boolean)true, (IPreferenceStore)ProjectExamplesActivator.getDefault().getPreferenceStore(), (String)"invalidSites");
            boolean toggleState = dialog.getToggleState();
            ProjectExamplesActivator.getDefault().getPreferenceStore().setValue("invalidSites", toggleState);
        }
        this.categories = nonEmptyCategories;
        return this.categories;
    }

    private String[] getItems() {
        TreeSet<String> sites = new TreeSet<String>();
        sites.add(ProjectExamplesActivator.ALL_SITES);
        for (ProjectExampleCategory category : this.categories) {
            List<ProjectExample> projects = category.getProjects();
            for (ProjectExample project : projects) {
                String name = project.getSite() == null ? ProjectExamplesActivator.ALL_SITES : project.getSite().getName();
                sites.add(name);
            }
        }
        String[] items = sites.toArray(new String[0]);
        return items;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public boolean refresh(boolean force) {
        boolean canFinish = false;
        for (Object object : this.selection) {
            if (object instanceof ProjectExample) {
                IImportProjectExample importProjectExample;
                canFinish = true;
                ProjectExampleWorkingCopy project = ProjectExamplesActivator.getDefault().getProjectExampleManager().createWorkingCopy((ProjectExample)object);
                String importType = project.getImportType();
                if ("zip".equals(importType) || importType == null || importType.length() <= 0 || (importProjectExample = ProjectExamplesActivator.getDefault().getImportProjectExample(importType)) != null) continue;
                canFinish = false;
                break;
            }
            canFinish = false;
            break;
        }
        return canFinish;
    }

    public ProjectExample getSelectedProject() {
        return this.selectedProject;
    }

    private static void restoreCombo(Combo combo, String initialValue) {
        int selectedIdx = combo.indexOf(initialValue);
        if (selectedIdx < 0) {
            selectedIdx = 0;
        }
        combo.select(selectedIdx);
    }

    public IWizardPage getNextPage() {
        ProjectExample projectExample;
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewProjectExamplesWizard2 && (projectExample = ((NewProjectExamplesWizard2)wizard).getSelectedProjectExample()) != null && projectExample.getImportType() != null) {
            List<IProjectExamplesWizardPage> pages = ((NewProjectExamplesWizard2)wizard).getContributedPages("requirement");
            for (IProjectExamplesWizardPage page : pages) {
                if (!projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                return page;
            }
        }
        return super.getNextPage();
    }

    private class ProjectContentProvider
    implements ITreeContentProvider {
        private ProjectContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AdaptableList) {
                Object[] childCollections = ((AdaptableList)parentElement).getChildren();
                return childCollections;
            }
            if (parentElement instanceof ProjectExampleCategory) {
                ProjectExampleCategory category = (ProjectExampleCategory)parentElement;
                return category.getProjects().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ProjectExample) {
                return ((ProjectExample)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ProjectExampleCategory;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ProjectExampleCategory) {
                ProjectExampleCategory category = (ProjectExampleCategory)element;
                return category.getName();
            }
            if (element instanceof ProjectExample) {
                ProjectExample project = (ProjectExample)element;
                return project.getShortDescription();
            }
            return super.getText(element);
        }
    }
}

