/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.fixes;

import org.jboss.tools.project.examples.fixes.IProjectFixProvider;
import org.jboss.tools.project.examples.fixes.UIHandler;
import org.jboss.tools.project.examples.internal.fixes.WTPRuntimeFix;
import org.jboss.tools.project.examples.internal.fixes.WTPRuntimeFixUIHandler;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;

public class RuntimeFixProvider
implements IProjectFixProvider {
    public static final String WTP_RUNTIME = "wtpruntime";

    public boolean accepts(String type) {
        return WTP_RUNTIME.equals(type);
    }

    @Override
    public WTPRuntimeFix create(ProjectExample project, RequirementModel requirement) {
        if (this.accepts(requirement.getType())) {
            return new WTPRuntimeFix(project, requirement);
        }
        throw new IllegalArgumentException(requirement == null ? null : String.valueOf(requirement.getType()) + " is not a valid runtime requirement");
    }

    @Override
    public UIHandler createUIHandler() {
        return new WTPRuntimeFixUIHandler();
    }
}

