/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.xml;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.NamespaceMapping;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;
import org.jboss.tools.seam.core.ISeamNamespace;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.event.ISeamValue;
import org.jboss.tools.seam.core.event.ISeamValueString;
import org.jboss.tools.seam.internal.core.SeamImport;
import org.jboss.tools.seam.internal.core.SeamProperty;
import org.jboss.tools.seam.internal.core.SeamValueList;
import org.jboss.tools.seam.internal.core.SeamValueMap;
import org.jboss.tools.seam.internal.core.SeamValueMapEntry;
import org.jboss.tools.seam.internal.core.SeamValueString;
import org.jboss.tools.seam.internal.core.SeamXmlComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamXmlFactory;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;

public class XMLScanner
implements IFileScanner {
    private XModel model;
    private XModelObject o;
    static Set<String> COMMON_ATTRIBUTES = new HashSet<String>();
    static Set<String> INTERNAL_ATTRIBUTES = new HashSet<String>();

    static {
        COMMON_ATTRIBUTES.add("name");
        COMMON_ATTRIBUTES.add("class");
        COMMON_ATTRIBUTES.add("scope");
        COMMON_ATTRIBUTES.add("precedence");
        COMMON_ATTRIBUTES.add("installed");
        COMMON_ATTRIBUTES.add("auto-create");
        COMMON_ATTRIBUTES.add("jndi-name");
        COMMON_ATTRIBUTES.add("startup");
        COMMON_ATTRIBUTES.add("startupDepends");
        INTERNAL_ATTRIBUTES.add("NAME");
        INTERNAL_ATTRIBUTES.add("EXTENSION");
        INTERNAL_ATTRIBUTES.add("#comment");
    }

    @Override
    public boolean isRelevant(IFile resource) {
        return resource.getName().equals("components.xml") || resource.getName().endsWith(".component.xml");
    }

    @Override
    public boolean isLikelyComponentSource(IFile f) {
        this.cleanState();
        boolean isComponentSource = false;
        if (f.isSynchronized(0) && f.exists()) {
            this.model = InnerModelHelper.createXModel((IProject)f.getProject());
            if (this.model != null) {
                this.o = EclipseResourceUtil.getObjectByResource((XModel)this.model, (IResource)f);
                if (this.o != null) {
                    isComponentSource = this.o.getModelEntity().getName().startsWith("FileSeamComponent");
                }
            }
        }
        if (!isComponentSource) {
            this.cleanState();
        }
        return isComponentSource;
    }

    private void cleanState() {
        this.model = null;
        this.o = null;
    }

    @Override
    public LoadedDeclarations parse(IFile f, ISeamProject sp) throws ScannerException {
        this.model = InnerModelHelper.createXModel((IProject)f.getProject());
        this.o = EclipseResourceUtil.getObjectByResource((XModel)this.model, (IResource)f);
        return this.parse(this.o, f.getFullPath(), sp);
    }

    public LoadedDeclarations parse(XModelObject o, IPath source, ISeamProject sp) {
        IFile f;
        NamespaceMapping nm = NamespaceMapping.load((XModelObject)o);
        if (o.getParent() instanceof FolderImpl && (f = ResourcesPlugin.getWorkspace().getRoot().getFile(source)) != null && f.exists()) {
            try {
                ((FolderImpl)o.getParent()).updateChildFile(o, f.getLocation().toFile());
            }
            catch (XModelException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            if (o.getParent() == null) {
                boolean b = this.isLikelyComponentSource(f);
                if (!b) {
                    return null;
                }
                if ((o = EclipseResourceUtil.getObjectByResource((XModel)o.getModel(), (IResource)f)) == null) {
                    return null;
                }
            }
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        String fileEntity = o.getModelEntity().getName();
        if (fileEntity.startsWith("FileSeamComponent") && !fileEntity.startsWith("FileSeamComponents")) {
            this.parseComponent(o, source, nm, sp, ds);
            return ds;
        }
        XModelObject[] os = o.getChildren();
        int i = 0;
        while (i < os.length) {
            String v;
            XModelEntity componentEntity = os[i].getModelEntity();
            if (componentEntity.getAttribute("class") != null) {
                this.parseComponent(os[i], source, nm, sp, ds);
            } else if (os[i].getModelEntity().getName().startsWith("SeamFactory")) {
                SeamXmlFactory factory = new SeamXmlFactory();
                factory.setId(os[i]);
                factory.setSourcePath(source);
                factory.setName((IValueInfo)new XMLValueInfo(os[i], "name"));
                factory.setScope((IValueInfo)new XMLValueInfo(os[i], "scope"));
                factory.setValue((IValueInfo)new XMLValueInfo(os[i], "value"));
                factory.setMethod((IValueInfo)new XMLValueInfo(os[i], "method"));
                ds.getFactories().add(factory);
            } else if (os[i].getModelEntity().getName().startsWith("SeamImport") && (v = os[i].getAttributeValue("import")) != null && v.length() > 0) {
                SeamImport s = new SeamImport();
                s.setSeamPackage(v);
                ds.getImports().add(s);
            }
            ++i;
        }
        return ds;
    }

    private void parseComponent(XModelObject c, IPath source, NamespaceMapping nm, ISeamProject sp, LoadedDeclarations ds) {
        SeamProperty p;
        SeamXmlComponentDeclaration component = new SeamXmlComponentDeclaration();
        component.setSourcePath(source);
        component.setId(c);
        component.setName((IValueInfo)new XMLValueInfo(c, this.getComponentAttribute(c)));
        if (this.isClassAttributeSet(c)) {
            component.setClassName((IValueInfo)new XMLValueInfo(c, "class"));
        } else if (c.getModelEntity().getName().equals("FileSeamComponent12")) {
            component.setClassName(XMLScanner.getImpliedClassName(c, source));
        } else {
            String className = XMLScanner.getDefaultClassName(c, nm, sp);
            if (className != null) {
                component.setClassName(className);
                component.setClassNameGuessed(true);
            }
        }
        component.setScope((IValueInfo)new XMLValueInfo(c, "scope"));
        component.setPrecedence((IValueInfo)new XMLValueInfo(c, "precedence"));
        component.setInstalled((IValueInfo)new XMLValueInfo(c, "installed"));
        component.setAutoCreate((IValueInfo)new XMLValueInfo(c, "auto-create"));
        component.setJndiName((IValueInfo)new XMLValueInfo(c, "jndi-name"));
        XAttribute[] attributes = c.getModelEntity().getAttributes();
        int ia = 0;
        while (ia < attributes.length) {
            XAttribute a = attributes[ia];
            String xml = a.getXMLName();
            if (!(xml == null || xml.length() == 0 || "#comment".equals(xml) || COMMON_ATTRIBUTES.contains(xml) || INTERNAL_ATTRIBUTES.contains(xml) || xml.indexOf(":") >= 0 || xml.startsWith("xmlns"))) {
                p = new SeamProperty();
                p.setId(xml);
                p.setName((IValueInfo)new XMLValueInfo(c, "&" + a.getName()));
                p.setName(XMLScanner.toCamelCase(xml, false));
                SeamValueString v = new SeamValueString();
                v.setId("value");
                p.setValue(v);
                v.setValue((IValueInfo)new XMLValueInfo(c, a.getName()));
                component.addProperty(p);
            }
            ++ia;
        }
        XModelObject[] properties = c.getChildren();
        int j = 0;
        while (j < properties.length) {
            XModelEntity entity = properties[j].getModelEntity();
            p = new SeamProperty();
            p.setId(properties[j]);
            p.setName((IValueInfo)new XMLValueInfo(properties[j], "name"));
            String name = properties[j].getAttributeValue("name");
            if (name == null) {
                SeamCorePlugin.getPluginLog().logWarning("Entity " + entity.getName() + " has no 'name' attribute");
            } else {
                String cname = XMLScanner.toCamelCase(name, false);
                if (!cname.equals(name)) {
                    p.setName(cname);
                }
                if (entity.getAttribute("value") != null) {
                    SeamValueString v = new SeamValueString();
                    v.setId(properties[j]);
                    v.setValue((IValueInfo)new XMLValueInfo(properties[j], "value"));
                    p.setValue(v);
                } else {
                    XModelObject[] entries = properties[j].getChildren();
                    if (entity.getChild("SeamListEntry") != null || "list".equals(entity.getProperty("childrenLoader"))) {
                        String ss;
                        ISeamValueString s;
                        ISeamValue v;
                        SeamValueList vl = new SeamValueList();
                        vl.setId(properties[j]);
                        int k = 0;
                        while (k < entries.length) {
                            v = new SeamValueString();
                            v.setId(entries[k]);
                            v.setValue((IValueInfo)new XMLValueInfo(entries[k], "value"));
                            vl.addValue((ISeamValueString)v);
                            ++k;
                        }
                        p.setValue(vl);
                        SeamProperty pa = (SeamProperty)component.getProperty(cname);
                        if (pa != null && (v = pa.getValue()) instanceof ISeamValueString && (s = (ISeamValueString)v).getValue() != null && (ss = s.getValue().getValue()) != null && ss.length() > 0) {
                            String[] qs = ss.split(",");
                            int i = 0;
                            while (i < qs.length) {
                                SeamValueString vi = new SeamValueString();
                                vi.setId(pa.getId());
                                ValueInfo info = new ValueInfo();
                                info.setValue(qs[i]);
                                vi.setValue((IValueInfo)info);
                                vl.addValue(vi);
                                ++i;
                            }
                        }
                    } else {
                        SeamValueMap vm = new SeamValueMap();
                        vm.setId(properties[j]);
                        int k = 0;
                        while (k < entries.length) {
                            SeamValueMapEntry e = new SeamValueMapEntry();
                            e.setId(entries[k]);
                            SeamValueString key = new SeamValueString();
                            key.setId(entries[k]);
                            key.setValue((IValueInfo)new XMLValueInfo(entries[k], "key"));
                            e.setKey(key);
                            SeamValueString value = new SeamValueString();
                            value.setId(entries[k]);
                            value.setValue((IValueInfo)new XMLValueInfo(entries[k], "value"));
                            e.setValue(value);
                            vm.addEntry(e);
                            ++k;
                        }
                        p.setValue(vm);
                    }
                }
                component.addProperty(p);
            }
            ++j;
        }
        ds.getComponents().add(component);
    }

    private String getComponentAttribute(XModelObject c) {
        if (c.getModelEntity().getAttribute("component-name") != null) {
            return "component-name";
        }
        return "name";
    }

    private boolean isClassAttributeSet(XModelObject c) {
        String value = c.getAttributeValue("class");
        return value != null && value.length() > 0;
    }

    public static String getImpliedClassName(XModelObject c, IPath path) {
        String suffix;
        if (EclipseResourceUtil.isJar((String)path.toString())) {
            String suffix2 = ".component";
            String cn = c.getAttributeValue("name");
            if (cn.endsWith(suffix2)) {
                cn = cn.substring(0, cn.length() - suffix2.length());
            }
            XModelObject p = c.getParent();
            while (p != null && p.getFileType() == 2) {
                cn = String.valueOf(p.getAttributeValue("name")) + "." + cn;
                p = p.getParent();
            }
            return cn;
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (!f.exists()) {
            return "";
        }
        IResource root = EclipseResourceUtil.getJavaSourceRoot((IProject)f.getProject());
        if (!root.getLocation().isPrefixOf(f.getLocation())) {
            return "";
        }
        String relative = f.getLocation().toString().substring(root.getLocation().toString().length());
        if (relative.endsWith(suffix = ".component.xml")) {
            relative = relative.substring(0, relative.length() - suffix.length());
            if ((relative = relative.replace('\\', '/')).startsWith("/")) {
                relative = relative.substring(1);
            }
            return relative.replace('/', '.');
        }
        return null;
    }

    public static String getDefaultClassName(XModelObject c, NamespaceMapping nm, ISeamProject sp) {
        Set<ISeamNamespace> set;
        String uri;
        String s = c.getModelEntity().getXMLSubPath();
        int d = s.indexOf(58);
        if (d < 0) {
            return null;
        }
        Map<String, Set<ISeamNamespace>> ns = sp == null ? null : sp.getNamespaces();
        String namespace = s.substring(0, d);
        String tag = s.substring(d + 1);
        String packageName = "org.jboss.seam." + namespace;
        String name = XMLScanner.toCamelCase(tag, true);
        if (nm != null && (uri = nm.getURIForDefaultNamespace(namespace)) != null && ns != null && !ns.isEmpty() && (set = ns.get(uri)) != null && !set.isEmpty()) {
            for (ISeamNamespace n : set) {
                String pn = n.getPackage();
                if (pn == null || pn.length() == 0) continue;
                String cn = String.valueOf(pn) + "." + name;
                packageName = pn;
                if (set.size() == 1) break;
                IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)sp.getProject());
                IType type = null;
                try {
                    type = EclipseJavaUtil.findType((IJavaProject)jp, (String)cn);
                }
                catch (JavaModelException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
                if (type != null) break;
            }
        }
        String className = String.valueOf(packageName) + "." + name;
        return className;
    }

    private static String toCamelCase(String hyphenated, boolean initialUpper) {
        StringTokenizer tokens = new StringTokenizer(hyphenated, "-");
        StringBuilder result = new StringBuilder(hyphenated.length());
        String firstToken = tokens.nextToken();
        if (initialUpper) {
            result.append(Character.toUpperCase(firstToken.charAt(0))).append(firstToken.substring(1));
        } else {
            result.append(firstToken);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(Character.toUpperCase(token.charAt(0))).append(token.substring(1));
        }
        return result.toString();
    }
}

