/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.event;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.project.ext.event.IChangeVisitor;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamProject;

public class SeamProjectChangeEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    ISeamProject project;
    List<Change> changes;

    public SeamProjectChangeEvent(ISeamProject project, List<Change> changes) {
        super(project);
        this.project = project;
        this.changes = changes;
    }

    public ISeamProject getProject() {
        return this.project;
    }

    public List<Change> getAllChanges() {
        return this.changes;
    }

    public void visit(IChangeVisitor visitor) {
        if (this.changes != null) {
            for (Change c : this.changes) {
                c.visit(visitor);
            }
        }
    }

    public List<ISeamComponent> getAllModifiedComponents() {
        final ArrayList<ISeamComponent> list = new ArrayList<ISeamComponent>();
        this.visit(new IChangeVisitor(){

            public boolean visit(Change change) {
                Object t = change.getTarget();
                if (t instanceof ISeamComponent) {
                    list.add((ISeamComponent)t);
                } else if (t instanceof ISeamProject) {
                    return true;
                }
                return false;
            }
        });
        return list;
    }
}

