/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;

public class SeamProjectsSet {
    IProject ear;
    IProject war;
    IProject ejb;
    IProject test;
    IProject[] childProjects = new IProject[0];
    IEclipsePreferences prefs;

    public static SeamProjectsSet create(IProject project) {
        return new SeamProjectsSet(project);
    }

    public SeamProjectsSet(IProject project) {
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(project, false);
        if (seamProject == null) {
            ISeamProject warProject = SeamUtil.findReferencingSeamWarProjectForProject(project);
            if (warProject != null) {
                this.initWebProject(warProject.getProject());
            }
        } else {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences preferences = projectScope.getNode("org.jboss.tools.seam.core");
            if (preferences != null) {
                String parentProjectName = preferences.get("seam.parent.project", null);
                if (parentProjectName == null) {
                    this.initWebProject(project);
                } else {
                    IProject warProject = ResourcesPlugin.getWorkspace().getRoot().getProject(parentProjectName);
                    if (warProject != null) {
                        this.initWebProject(warProject);
                    }
                }
            }
        }
    }

    public void initWebProject(IProject warProject) {
        ProjectScope projectScope = new ProjectScope(warProject);
        this.prefs = projectScope.getNode("org.jboss.tools.seam.core");
        this.war = warProject;
        if (this.prefs != null) {
            String testName;
            String ejbName;
            String earName = this.prefs.get("seam.ear.project", String.valueOf(warProject.getName()) + "-ear");
            if (earName != null && !"".equals(earName.trim())) {
                this.ear = (IProject)warProject.getWorkspace().getRoot().findMember(earName);
            }
            if ((ejbName = this.prefs.get("seam.ejb.project", String.valueOf(warProject.getName()) + "-ejb")) != null && !"".equals(ejbName.trim())) {
                this.ejb = (IProject)warProject.getWorkspace().getRoot().findMember(ejbName);
            }
            if ((testName = this.prefs.get("seam.test.project", String.valueOf(warProject.getName()) + "test")) != null && !"".equals(testName)) {
                this.test = (IProject)warProject.getWorkspace().getRoot().findMember(testName);
            }
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            HashSet<IProject> childProjectSet = new HashSet<IProject>();
            int i = 0;
            while (i < projects.length) {
                String parentProjectName;
                IEclipsePreferences preferences;
                ISeamProject seamProject = SeamCorePlugin.getSeamProject(projects[i], false);
                if (seamProject != null && (preferences = (projectScope = new ProjectScope(projects[i])).getNode("org.jboss.tools.seam.core")) != null && (parentProjectName = preferences.get("seam.parent.project", null)) != null && parentProjectName.equals(warProject.getName())) {
                    childProjectSet.add(projects[i]);
                }
                ++i;
            }
            this.childProjects = childProjectSet.toArray(new IProject[childProjectSet.size()]);
        }
    }

    public IProject[] getChildProjects() {
        return this.childProjects;
    }

    public IProject[] getAllProjects() {
        IProject[] projects = new IProject[this.childProjects.length + 1];
        int i = 0;
        while (i < this.childProjects.length) {
            projects[i] = this.childProjects[i];
            ++i;
        }
        projects[this.childProjects.length] = this.war;
        return projects;
    }

    public String getDefaultDeployType() {
        if (this.ejb != null && this.war != this.ejb) {
            return "ear";
        }
        return "war";
    }

    public boolean isWarConfiguration() {
        if (this.prefs == null) {
            return false;
        }
        return this.prefs.get("seam.project.deployment.type", "war").equals("war");
    }

    public IProject getWarProject() {
        return this.war;
    }

    public IProject getEarProject() {
        return this.ear;
    }

    public IProject getEjbProject() {
        return this.ejb;
    }

    public IProject getTestProject() {
        return this.test;
    }

    public IContainer getDefaultActionFolder() {
        return this.getDefaultEjbSourceFolder();
    }

    public IContainer getActionFolder() {
        String folderPath = null;
        if (this.prefs != null) {
            folderPath = this.prefs.get("action.sources", null);
        }
        if (folderPath == null || folderPath.length() == 0) {
            return this.getDefaultActionFolder();
        }
        return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
    }

    public IContainer getDefaultModelFolder() {
        return this.getDefaultEjbSourceFolder();
    }

    public IContainer getModelFolder() {
        String folderPath = null;
        if (this.prefs != null) {
            folderPath = this.prefs.get("model.sources", null);
        }
        if (folderPath == null || folderPath.length() == 0) {
            return this.getDefaultModelFolder();
        }
        return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
    }

    public IContainer getDefaultEjbSourceFolder() {
        return this.getSrc(this.ejb);
    }

    public IContainer getDefaultTestSourceFolder() {
        return this.getSrc(this.test);
    }

    public IContainer getDefaultWarSourceFolder() {
        IFolder webSrcFolder = this.findWebSrcFolder();
        if (webSrcFolder != null) {
            return webSrcFolder;
        }
        return this.getSrc(this.war);
    }

    private IContainer getSrc(IProject project) {
        IResource resource;
        if (project == null) {
            project = this.war;
        }
        if ((resource = EclipseResourceUtil.getJavaSourceRoot((IProject)project)) != null) {
            return (IContainer)resource;
        }
        return project;
    }

    public IContainer getDefaultViewsFolder() {
        IVirtualFolder webRootFolder;
        IVirtualComponent com = ComponentCore.createComponent((IProject)this.war);
        if (com != null && (webRootFolder = com.getRootFolder().getFolder((IPath)new Path("/"))) != null) {
            return (IFolder)webRootFolder.getUnderlyingFolder();
        }
        return this.getWarProject();
    }

    public IContainer getDefaultEarViewsFolder() {
        IVirtualFolder webRootFolder;
        IVirtualComponent com = ComponentCore.createComponent((IProject)this.ear);
        if (com != null && (webRootFolder = com.getRootFolder().getFolder((IPath)new Path("/"))) != null) {
            return (IFolder)webRootFolder.getUnderlyingFolder();
        }
        return this.getWarProject();
    }

    public IContainer getViewsFolder() {
        String folderPath = null;
        if (this.prefs != null) {
            folderPath = this.prefs.get("seam.project.web.root.folder", null);
        }
        if (folderPath == null || folderPath.length() == 0) {
            return this.getDefaultViewsFolder();
        }
        return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
    }

    public IContainer getTestsFolder() {
        String folderPath = null;
        if (this.prefs != null) {
            folderPath = this.prefs.get("test.sources", null);
        }
        if (folderPath == null || folderPath.length() == 0) {
            return this.getDefaultTestSourceFolder();
        }
        return (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(folderPath);
    }

    public String getEntityPackage() {
        if (this.prefs == null) {
            return "entity";
        }
        return this.prefs.get("model.package", "entity");
    }

    public void refreshLocal(IProgressMonitor monitor) throws CoreException {
        if (this.ejb != null) {
            this.ejb.refreshLocal(2, monitor);
        }
        if (this.test != null) {
            this.test.refreshLocal(2, monitor);
        }
        if (this.war != null) {
            this.war.refreshLocal(2, monitor);
        }
    }

    private IFolder findWebSrcFolder() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.war);
        if (component != null) {
            IVirtualFolder vFolder = component.getRootFolder().getFolder("WEB-INF/classes");
            return (IFolder)vFolder.getUnderlyingFolder();
        }
        return null;
    }
}

