/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.validation.ValidationSeverityPreferences;

public class SeamPreferences
extends ValidationSeverityPreferences {
    public static final Set<String> SEVERITY_OPTION_NAMES = new HashSet<String>();
    private static SeamPreferences INSTANCE = new SeamPreferences();
    public static final String WARNING_GROUP_ID = "seam";
    public static final String NONUNIQUE_COMPONENT_NAME = INSTANCE.createSeverityOption("nonUniqueComponentName", new String[]{"duplicated-component"});
    public static final String STATEFUL_COMPONENT_DOES_NOT_CONTENT_REMOVE = INSTANCE.createSeverityOption("statefulComponentDoesNotContainRemove", new String[]{"remove"});
    public static final String STATEFUL_COMPONENT_DOES_NOT_CONTENT_DESTROY = INSTANCE.createSeverityOption("statefulComponentDoesNotContainDestroy", new String[]{"destroy"});
    public static final String STATEFUL_COMPONENT_WRONG_SCOPE = INSTANCE.createSeverityOption("statefulComponentHasWrongScope", new String[]{"scope"});
    public static final String UNKNOWN_COMPONENT_CLASS_NAME = INSTANCE.createSeverityOption("unknownComponentClassName", new String[]{"unknown-component"});
    public static final String UNKNOWN_COMPONENT_CLASS_NAME_GUESS = INSTANCE.createSeverityOption("unknownComponentClassNameGuess", new String[]{"unknown-component"});
    public static final String UNKNOWN_COMPONENT_PROPERTY = INSTANCE.createSeverityOption("unknownComponentProperty", new String[]{"unknown-property"});
    public static final String ENTITY_COMPONENT_WRONG_SCOPE = INSTANCE.createSeverityOption("entityComponentHasWrongScope", new String[]{"entity"});
    public static final String DUPLICATE_REMOVE = INSTANCE.createSeverityOption("duplicateRemove", new String[]{"remove"});
    public static final String DUPLICATE_DESTROY = INSTANCE.createSeverityOption("duplicateDestroy", new String[]{"duplicated-method"});
    public static final String DUPLICATE_CREATE = INSTANCE.createSeverityOption("duplicateCreate", new String[]{"duplicated-method"});
    public static final String DUPLICATE_UNWRAP = INSTANCE.createSeverityOption("duplicateUnwrap", new String[]{"duplicated-method"});
    public static final String DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN = INSTANCE.createSeverityOption("destroyMethodBelongsToStatelessSessionBean", new String[]{"destroy"});
    public static final String CREATE_DOESNT_BELONG_TO_COMPONENT = INSTANCE.createSeverityOption("createDoesNotBelongToComponent", new String[]{"unused-method"});
    public static final String UNWRAP_DOESNT_BELONG_TO_COMPONENT = INSTANCE.createSeverityOption("unwrapDoesNotBelongToComponent", new String[]{"unused-method"});
    public static final String OBSERVER_DOESNT_BELONG_TO_COMPONENT = INSTANCE.createSeverityOption("observerDoesNotBelongToComponent", new String[]{"unused-method"});
    public static final String UNKNOWN_FACTORY_NAME = INSTANCE.createSeverityOption("unknownFactoryName", new String[]{"factory"});
    public static final String MULTIPLE_DATA_BINDER = INSTANCE.createSeverityOption("multipleDataBinder", new String[]{"ambiguous-data"});
    public static final String UNKNOWN_DATA_MODEL = INSTANCE.createSeverityOption("unknownDataModel", new String[]{"ambiguous-data"});
    public static final String DUPLICATE_VARIABLE_NAME = INSTANCE.createSeverityOption("duplicateVariableName", new String[]{"duplicated-variable"});
    public static final String UNKNOWN_VARIABLE_NAME = INSTANCE.createSeverityOption("unknownVariableName", new String[]{"unresolved-variable"});
    public static final String UNRESOLVED_VIEW_ID = INSTANCE.createSeverityOption("unresolvedViewID", new String[]{"unresolved-view"});
    public static final String INVALID_PROJECT_SETTINGS = INSTANCE.createSeverityOption("invalidProjectSettings");
    public static final String INVALID_XML_VERSION = INSTANCE.createSeverityOption("invalidXMLVersion");

    public static SeamPreferences getInstance() {
        return INSTANCE;
    }

    private SeamPreferences() {
    }

    public String getWarningGroupID() {
        return WARNING_GROUP_ID;
    }

    protected String createSeverityOption(String shortName) {
        String name = String.valueOf(this.getPluginId()) + ".validator.problem." + shortName;
        SEVERITY_OPTION_NAMES.add(name);
        return name;
    }

    protected String getPluginId() {
        return "org.jboss.tools.seam.core";
    }

    protected Set<String> getSeverityOptionNames() {
        return SEVERITY_OPTION_NAMES;
    }

    public static boolean shouldValidateCore(IProject project) {
        return !"ignore".equals(INSTANCE.getProjectPreference(project, NONUNIQUE_COMPONENT_NAME)) || !"ignore".equals(INSTANCE.getProjectPreference(project, STATEFUL_COMPONENT_DOES_NOT_CONTENT_REMOVE)) || !"ignore".equals(INSTANCE.getProjectPreference(project, STATEFUL_COMPONENT_DOES_NOT_CONTENT_DESTROY)) || !"ignore".equals(INSTANCE.getProjectPreference(project, STATEFUL_COMPONENT_WRONG_SCOPE)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_COMPONENT_CLASS_NAME)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_COMPONENT_PROPERTY)) || !"ignore".equals(INSTANCE.getProjectPreference(project, ENTITY_COMPONENT_WRONG_SCOPE)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DUPLICATE_REMOVE)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DUPLICATE_DESTROY)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DUPLICATE_CREATE)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DUPLICATE_UNWRAP)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN)) || !"ignore".equals(INSTANCE.getProjectPreference(project, CREATE_DOESNT_BELONG_TO_COMPONENT)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNWRAP_DOESNT_BELONG_TO_COMPONENT)) || !"ignore".equals(INSTANCE.getProjectPreference(project, OBSERVER_DOESNT_BELONG_TO_COMPONENT)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_FACTORY_NAME)) || !"ignore".equals(INSTANCE.getProjectPreference(project, MULTIPLE_DATA_BINDER)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_DATA_MODEL)) || !"ignore".equals(INSTANCE.getProjectPreference(project, DUPLICATE_VARIABLE_NAME)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_VARIABLE_NAME));
    }

    public static boolean shouldValidateSettings(IProject project) {
        return !"ignore".equals(INSTANCE.getProjectPreference(project, INVALID_PROJECT_SETTINGS));
    }

    public static boolean isValidationEnabled(IProject project) {
        return INSTANCE.isEnabled(project);
    }

    public static int getMaxNumberOfProblemMarkersPerFile(IProject project) {
        return INSTANCE.getMaxNumberOfProblemMarkersPerResource(project);
    }
}

