/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.chain.rcp;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.internal.ui.javaeditor.SpecificContentAssistExecutor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.ui.texteditor.ITextEditor;

public final class CompletionKeyShortcutHandler
extends AbstractHandler {
    private static final String CHAIN_COMPLETION_CATEGORY = "org.eclipse.recommenders.completion.rcp.chain.category";
    private final CompletionProposalComputerRegistry registry = CompletionProposalComputerRegistry.getDefault();
    private final SpecificContentAssistExecutor executor = new SpecificContentAssistExecutor(this.registry);

    public CompletionKeyShortcutHandler() {
        this.validateChainCompletionCategoryExists();
    }

    private void validateChainCompletionCategoryExists() {
        List categories = this.registry.getProposalCategories();
        for (CompletionProposalCategory c : categories) {
            if (!c.getId().equals(CHAIN_COMPLETION_CATEGORY)) continue;
            return;
        }
        Throws.throwIllegalStateException((String)"Chain proposal engine category '%s' no found. Report this as bug.", (Object[])new Object[]{CHAIN_COMPLETION_CATEGORY});
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional opt = JdtUtils.getActiveJavaEditor();
        if (!opt.isPresent()) {
            return null;
        }
        this.executor.invokeContentAssist((ITextEditor)opt.get(), CHAIN_COMPLETION_CATEGORY);
        return null;
    }
}

