/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core;

import org.eclipse.core.runtime.Plugin;
import org.jboss.tools.openshift.internal.common.core.OpenShiftCommonCoreActivator;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;

public class UsageStats {
    private static final String OPENSHIFT_COMPONENT = "openshift";
    private static final int SUCCESS = 1;
    private static final int FAILURE = 0;
    private static final String HOSTTYPE_OTHER = "other";
    private static UsageStats INSTANCE = null;
    private UsageEventType newConnectionV2 = this.createEventType("new_connection_v2", "host type: redhat/other", null);
    private UsageEventType newApplicationV2 = this.createEventType("new_app_v2", "host type: redhat/other", UsageEventType.SUCCESFULL_FAILED_VALUE_DESCRIPTION);
    private UsageEventType importApplicationV2 = this.createEventType("import_app_v2", "host type: redhat/other", UsageEventType.SUCCESFULL_FAILED_VALUE_DESCRIPTION);
    private UsageEventType newConnectionV3 = this.createEventType("new_connection_v3", "host type: redhat/other", null);
    private UsageEventType newApplicationV3 = this.createEventType("new_app_v3", "host type: redhat/other", UsageEventType.SUCCESFULL_FAILED_VALUE_DESCRIPTION);
    private UsageEventType importApplicationV3 = this.createEventType("import_app_v3", "host type: redhat/other", UsageEventType.SUCCESFULL_FAILED_VALUE_DESCRIPTION);

    public static UsageStats getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UsageStats();
        }
        return INSTANCE;
    }

    private UsageStats() {
    }

    private UsageEventType createEventType(String actionName, String labelDescription, String valueDescription) {
        UsageEventType eventType = new UsageEventType(OPENSHIFT_COMPONENT, UsageEventType.getVersion((Plugin)OpenShiftCommonCoreActivator.getDefault()), null, actionName, labelDescription, valueDescription);
        UsageReporter.getInstance().registerEvent(eventType);
        return eventType;
    }

    public void newV2Connection(String host) {
        UsageReporter.getInstance().trackEvent(this.newConnectionV2.event(UsageStats.getHostType(host)));
    }

    public void newV2Application(String host, boolean success) {
        UsageReporter.getInstance().trackEvent(this.newApplicationV2.event(UsageStats.getHostType(host), success ? 1 : 0));
    }

    public void importV2Application(String host, boolean success) {
        UsageReporter.getInstance().trackEvent(this.importApplicationV2.event(UsageStats.getHostType(host), success ? 1 : 0));
    }

    public void newV3Connection(String host) {
        UsageReporter.getInstance().trackEvent(this.newConnectionV3.event(UsageStats.getHostType(host)));
    }

    public void newV3Application(String host, boolean success) {
        UsageReporter.getInstance().trackEvent(this.newApplicationV3.event(UsageStats.getHostType(host), success ? 1 : 0));
    }

    public void importV3Application(String host, boolean success) {
        UsageReporter.getInstance().trackEvent(this.importApplicationV3.event(UsageStats.getHostType(host), success ? 1 : 0));
    }

    private static String getHostType(String host) {
        if (host == null) {
            return HOSTTYPE_OTHER;
        }
        String lowercaseHost = host.toLowerCase();
        if (lowercaseHost.contains("redhat") || lowercaseHost.endsWith("openshift.com")) {
            return host;
        }
        return HOSTTYPE_OTHER;
    }
}

