/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.OpenShiftCoreException;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.connection.IConnectionsRegistryListener;

public class ConnectionsRegistry {
    private static final int ADDED = 0;
    private static final int REMOVED = 1;
    private static final int CHANGED = 2;
    private IConnection recentConnection = null;
    private Map<ConnectionURL, IConnection> connectionsByUrl = new HashMap<ConnectionURL, IConnection>();
    private List<IConnectionsRegistryListener> listeners = new ArrayList<IConnectionsRegistryListener>();
    private PropertyChangeListener connectionListener = new ConnectionListener();

    public void addListener(IConnectionsRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IConnectionsRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        IConnection[] connections;
        IConnection[] iConnectionArray = connections = this.connectionsByUrl.values().toArray(new IConnection[this.connectionsByUrl.size()]);
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnection connection = iConnectionArray[n2];
            this.remove(connection);
            ++n2;
        }
    }

    public boolean add(IConnection connection) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection(connection);
            return this.add(connectionUrl, connection);
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, "Could not add connection {0}", connection.getHost());
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, "Could not add connection {0}", connection.getHost());
        }
    }

    public void addAll(Collection<? extends IConnection> connections) {
        for (IConnection iConnection : connections) {
            this.add(iConnection);
        }
    }

    protected boolean add(ConnectionURL connectionUrl, IConnection connection) {
        if (this.connectionsByUrl.containsKey(connectionUrl)) {
            return false;
        }
        this.addPropertyChangeListener(connection);
        this.connectionsByUrl.put(connectionUrl, connection);
        this.recentConnection = connection;
        this.fireChange(connection, 0);
        return true;
    }

    public boolean has(IConnection connection) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection(connection);
            return this.getByUrl(connectionUrl) != null;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not get url for connection {0}", (Object)connection.getHost()), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not get url for connection {0}", (Object)connection.getHost()), new Object[0]);
        }
    }

    public void fireConnectionChanged(IConnection connection) {
        this.fireConnectionChanged(connection, null, null, null);
    }

    public void fireConnectionChanged(IConnection connection, String property, Object oldValue, Object newValue) {
        if (connection == null) {
            return;
        }
        this.fireChange(connection, 2, property, oldValue, newValue);
    }

    public boolean remove(IConnection connection) {
        ConnectionURL connectionUrl;
        block5: {
            connectionUrl = ConnectionURL.forConnection(connection);
            if (this.connectionsByUrl.containsKey(connectionUrl)) break block5;
            return false;
        }
        try {
            this.connectionsByUrl.remove(connectionUrl);
            this.removePropertyChangeListener(connection);
            if (this.recentConnection == connection) {
                this.recentConnection = null;
            }
            this.fireChange(connection, 1);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not remove connection {0}", (Object)connection.getHost()), new Object[0]);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not remove connection {0}", (Object)connection.getHost()), new Object[0]);
        }
    }

    private void fireChange(IConnection connection, int event) {
        this.fireChange(connection, event, null, null, null);
    }

    private void fireChange(IConnection connection, int event, String property, Object oldValue, Object newValue) {
        if (connection == null) {
            return;
        }
        for (IConnectionsRegistryListener l : this.listeners) {
            switch (event) {
                case 0: {
                    l.connectionAdded(connection);
                    break;
                }
                case 1: {
                    l.connectionRemoved(connection);
                    break;
                }
                case 2: {
                    l.connectionChanged(connection, property, oldValue, newValue);
                    break;
                }
            }
        }
    }

    public IConnection getRecentConnection() {
        return this.recentConnection;
    }

    public <T extends IConnection> T getRecentConnection(Class<T> clazz) {
        if (this.recentConnection == null || !clazz.isAssignableFrom(this.recentConnection.getClass())) {
            return null;
        }
        return (T)this.recentConnection;
    }

    public IConnection getByUrl(ConnectionURL connectionUrl) {
        if (connectionUrl == null) {
            return null;
        }
        return this.connectionsByUrl.get(connectionUrl);
    }

    public <T extends IConnection> T getByUrl(ConnectionURL connectionUrl, Class<T> clazz) {
        IConnection connection = this.getByUrl(connectionUrl);
        if (connection != null && !clazz.isAssignableFrom(connection.getClass())) {
            return null;
        }
        return (T)connection;
    }

    public <T extends IConnection> Collection<T> getAll(Class<T> clazz) {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        for (IConnection connection : this.connectionsByUrl.values()) {
            if (connection == null || !clazz.isAssignableFrom(connection.getClass())) continue;
            connections.add(connection);
        }
        return connections;
    }

    public Collection<IConnection> getAll() {
        return this.connectionsByUrl.values();
    }

    public int size() {
        return this.connectionsByUrl.size();
    }

    public IConnection setRecent(IConnection connection) {
        this.recentConnection = connection;
        return this.recentConnection;
    }

    private void addPropertyChangeListener(IConnection connection) {
        if (!(connection instanceof ObservablePojo)) {
            return;
        }
        ((ObservablePojo)connection).addPropertyChangeListener(this.connectionListener);
    }

    private void removePropertyChangeListener(IConnection connection) {
        if (!(connection instanceof ObservablePojo)) {
            return;
        }
        ((ObservablePojo)connection).removePropertyChangeListener(this.connectionListener);
    }

    public void update(IConnection currentConnection, IConnection updatedConnection) {
        boolean seriousChange;
        ConnectionURL updatedConnectionUrl = null;
        try {
            updatedConnectionUrl = ConnectionURL.forConnection(updatedConnection);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not update connection {0}", (Object)updatedConnection.getHost()), new Object[0]);
        }
        ConnectionURL oldConnectionUrl = null;
        try {
            oldConnectionUrl = ConnectionURL.forConnection(currentConnection);
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new OpenShiftCoreException(e, NLS.bind((String)"Could not update connection {0}", (Object)currentConnection.getHost()), new Object[0]);
        }
        if (!oldConnectionUrl.equals(updatedConnectionUrl)) {
            this.connectionsByUrl.remove(oldConnectionUrl);
        }
        boolean bl = seriousChange = !updatedConnection.equals(currentConnection);
        if (seriousChange) {
            this.remove(currentConnection);
        }
        currentConnection.update(updatedConnection);
        if (seriousChange) {
            this.add(currentConnection);
        }
        this.recentConnection = currentConnection;
    }

    private class ConnectionListener
    implements PropertyChangeListener {
        private ConnectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (!(event.getSource() instanceof IConnection)) {
                return;
            }
            ConnectionsRegistry.this.fireConnectionChanged((IConnection)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }
}

