/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.UrlUtils;

public abstract class AbstractConnectionPersistency<C extends IConnection> {
    public Collection<C> load() {
        String[] persistedConnections;
        ArrayList<String> connections = new ArrayList<String>();
        String[] stringArray = persistedConnections = this.loadPersisted();
        int n = persistedConnections.length;
        int n2 = 0;
        while (n2 < n) {
            String connectionUrl = stringArray[n2];
            this.addConnection((C)connectionUrl, (List<String>)connections);
            ++n2;
        }
        return connections;
    }

    private void addConnection(String connectionUrl, List<C> connections) {
        try {
            C connection = this.createConnection(this.createConnectionURL(connectionUrl));
            if (connection != null) {
                connections.add(connection);
            }
        }
        catch (MalformedURLException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrl), e);
        }
        catch (UnsupportedEncodingException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrl), e);
        }
        catch (IllegalArgumentException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}.", (Object)connectionUrl), e);
        }
    }

    private ConnectionURL createConnectionURL(String connectionUrl) throws UnsupportedEncodingException, MalformedURLException {
        if (UrlUtils.hasScheme(connectionUrl)) {
            return ConnectionURL.forURL(connectionUrl);
        }
        return ConnectionURL.forUsername(connectionUrl);
    }

    public void save(Collection<C> connections) {
        if (connections == null) {
            return;
        }
        ArrayList<String> serializedConnections = new ArrayList<String>(connections.size());
        for (IConnection connection : connections) {
            this.addConnection(connection, serializedConnections);
        }
        this.persist(serializedConnections.toArray(new String[serializedConnections.size()]));
    }

    private void addConnection(C connection, List<String> serializedConnections) {
        try {
            ConnectionURL connectionURL = ConnectionURL.forConnection(connection);
            serializedConnections.add(connectionURL.toString());
        }
        catch (MalformedURLException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}@{1}.", (Object)connection.getUsername(), (Object)connection.getHost()), e);
        }
        catch (UnsupportedEncodingException e) {
            this.logError(NLS.bind((String)"Could not add connection for {0}@{1}.", (Object)connection.getUsername(), (Object)connection.getHost()), e);
        }
    }

    protected abstract String[] loadPersisted();

    protected abstract void persist(String[] var1);

    protected abstract void logError(String var1, Exception var2);

    protected abstract C createConnection(ConnectionURL var1);
}

