/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.modules.ResourceModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilterProvider;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPrimaryPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishControllerDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;
import org.jboss.tools.as.core.server.controllable.internal.DeployableServerBehavior;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;
import org.jboss.tools.as.core.server.controllable.util.PublishControllerUtility;

public class ManagementPublishController
extends AbstractSubsystemController
implements IPublishController,
IPrimaryPublishController {
    private IJBoss7ManagerService service;
    private AS7ManagementDetails managementDetails;
    private IModuleStateController moduleStateController;
    private boolean moduleStateControllerLoadFailed = false;
    private IModuleDeployPathController moduleDeployPathController;

    private IJBoss7ManagerService getService() {
        if (this.service == null) {
            this.service = JBoss7ManagerUtil.getService((IServer)this.getServer());
            this.managementDetails = new AS7ManagementDetails(this.getServer());
        }
        return this.service;
    }

    public IStatus validate() {
        try {
            IStatus sup = super.validate();
            if (!sup.isOK()) {
                return sup;
            }
            this.getDeployPathController();
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus isRunning() {
        if (this.getServer().getServerState() != 2) {
            return Status.CANCEL_STATUS;
        }
        Exception e = null;
        try {
            JBoss7ServerState serverState = null;
            serverState = this.getService().getServerState((IAS7ManagementDetails)this.managementDetails);
            if (serverState == JBoss7ServerState.RUNNING) {
                return Status.OK_STATUS;
            }
        }
        catch (Exception e2) {
            e = e2;
        }
        return new Status(4, "org.jboss.ide.eclipse.as.core", "JBossTools is unable to verify that the server is up and responsive.", (Throwable)e);
    }

    public IStatus canPublish() {
        return this.canPublishInternal(false);
    }

    private IStatus canPublishInternal(boolean checkServerResponds) {
        IStatus isRunningStatus;
        boolean started;
        boolean bl = started = this.getServer().getServerState() == 2;
        if (!started) {
            return Status.CANCEL_STATUS;
        }
        if (checkServerResponds && !(isRunningStatus = this.isRunning()).isOK()) {
            return isRunningStatus;
        }
        return this.validate();
    }

    public boolean canPublishModule(IModule[] module) {
        return this.canPublishInternal(false).isOK();
    }

    public void publishStart(IProgressMonitor monitor) throws CoreException {
        IStatus canPublish = this.canPublishInternal(true);
        if (!canPublish.isOK() && this.canPublish().getSeverity() != 8) {
            throw new CoreException(canPublish);
        }
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        IServer s = this.getServer();
        ((Server)s).setServerPublishState(this.getUpdatedPublishState(s));
        IModuleStateController c = this.getModuleStateController();
        if (c != null && this.getServer().getServerState() == 2) {
            new UpdateModuleStateJob(c, this.getServer(), true, 15000).schedule(5000L);
        }
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        if (this.moduleStateController == null && !this.moduleStateControllerLoadFailed) {
            try {
                DeployableServerBehavior o = (DeployableServerBehavior)((Object)this.getServer().loadAdapter(DeployableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor()));
                this.moduleStateController = (IModuleStateController)o.getController("modules");
            }
            catch (CoreException coreException) {
                this.moduleStateControllerLoadFailed = true;
            }
        }
        return this.moduleStateController;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.moduleDeployPathController == null) {
            this.moduleDeployPathController = (IModuleDeployPathController)this.findDependencyFromBehavior("moduleDeployPath");
        }
        return this.moduleDeployPathController;
    }

    protected boolean shouldMinimizeRedeployments() {
        boolean debugMode = "debug".equals(this.getServer().getMode());
        Object o = this.getControllableBehavior().getSharedData("AbstractStartJavaServerLaunchDelegate.HotCodeReplaceOverridden");
        return debugMode && o instanceof Boolean && (Boolean)o != false;
    }

    public int publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        int i;
        IStatus canPublish = this.canPublishInternal(true);
        if (!canPublish.isOK() && canPublish.getSeverity() != 8) {
            Status error = new Status(4, "org.jboss.ide.eclipse.as.core", "The server must be started to publish.");
            throw new CoreException((IStatus)error);
        }
        if (canPublish.getSeverity() == 8) {
            return this.getServer().getModulePublishState(module);
        }
        if (module.length > 1) {
            return 1;
        }
        ((Server)this.getServer()).setModuleState(module, 0);
        IPublishControllerDelegate delegate = PublishControllerUtility.findDelegatePublishController((IServer)this.getServer(), (IModule[])module, (boolean)true);
        if (delegate != null) {
            return delegate.publishModule(kind, deltaKind, module, monitor);
        }
        int publishType = PublishControllerUtility.getPublishType((IServer)this.getServer(), (IModule[])module, (int)kind, (int)deltaKind);
        if (publishType == 0) {
            return this.getServer().getModulePublishState(module);
        }
        if (publishType == 1 && this.shouldMinimizeRedeployments()) {
            return this.getServer().getModulePublishState(module);
        }
        if (publishType == 3) {
            return this.removeModule(module, monitor);
        }
        monitor.setTaskName("Publishing " + module[0].getName());
        boolean isBinaryObject = ServerModelUtilities.isBinaryModule((IModule[])module);
        File[] toTransfer = null;
        if (!isBinaryObject) {
            monitor.setTaskName("Zipping module: " + module[0].getName());
            IProgressMonitor submon = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)200);
            File file = this.zipLocally(module[0], publishType, submon);
            toTransfer = new File[]{file};
            submon.done();
        } else {
            IModuleResource[] resources = ModuleResourceUtil.getMembers((IModule)module[0]);
            ArrayList<File> fileList = new ArrayList<File>(resources.length);
            i = 0;
            while (i < resources.length) {
                File f = (File)resources[i].getAdapter(File.class);
                if (f != null) {
                    fileList.add(f);
                }
                ++i;
            }
            toTransfer = fileList.toArray(new File[fileList.size()]);
            monitor.worked(200);
        }
        if (toTransfer != null) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 1644298251, "Deployment of module " + module[0].getName() + " has failed", null);
            IProgressMonitor transferMonitor = ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)800);
            transferMonitor.beginTask("Transfering " + module[0].getName(), 100 * toTransfer.length);
            i = 0;
            while (i < toTransfer.length) {
                JBoss7DeploymentState state = this.getService().getDeploymentState((IAS7ManagementDetails)this.managementDetails, toTransfer[i].getName());
                if (state != JBoss7DeploymentState.NOT_FOUND) {
                    monitor.setTaskName("Undeploying: " + toTransfer[i].getName());
                    IJBoss7DeploymentResult removeResult = this.getService().undeploySync((IAS7ManagementDetails)this.managementDetails, toTransfer[i].getName(), true, ProgressMonitorUtil.submon((IProgressMonitor)transferMonitor, (int)5));
                    ms.add(removeResult.getStatus());
                } else {
                    transferMonitor.worked(5);
                }
                monitor.setTaskName("Transfering: " + toTransfer[i].getName());
                IJBoss7DeploymentResult result = this.getService().deploySync((IAS7ManagementDetails)this.managementDetails, toTransfer[i].getName(), toTransfer[i], true, ProgressMonitorUtil.submon((IProgressMonitor)transferMonitor, (int)95));
                IStatus s = result.getStatus();
                ms.add(s);
                ++i;
            }
            if (ms.isOK()) {
                return 1;
            }
            ServerLogger.getDefault().log(this.getServer(), (IStatus)ms);
            transferMonitor.done();
            return 3;
        }
        return 0;
    }

    private String getDeploymentOutputName(IServer server, IModule module) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        if (beh != null) {
            IModule[] moduleToTest = new IModule[]{module};
            IModuleDeployPathController controller = this.getDeployPathController();
            return controller.getOutputName(moduleToTest);
        }
        return null;
    }

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 100);
        monitor.done();
    }

    private File zipLocally(IModule module, int publishType, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Zip module " + module.getName(), 100);
        IPath localTempLocation = this.getMetadataTemporaryLocation(this.getServer());
        String name = this.getDeploymentOutputName(this.getServer(), module);
        IPath tmpArchive = localTempLocation.append(name);
        LocalZippedModulePublishRunner runner = this.createZippedRunner(module, tmpArchive);
        IStatus result = null;
        if (publishType == 2) {
            result = runner.fullPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        } else if (publishType == 1) {
            result = runner.incrementalPublishModule(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        }
        monitor.done();
        if (result != null && result.isOK() && tmpArchive.toFile().exists()) {
            return tmpArchive.toFile();
        }
        throw new CoreException(result);
    }

    private IPath getMetadataTemporaryLocation(IServer server) {
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation(server).append("tempRemoteDeploy").makeAbsolute();
        deployRoot.toFile().mkdirs();
        return deployRoot;
    }

    private IModulePathFilterProvider getModulePathFilterProvider() {
        return new IModulePathFilterProvider(){

            public IModulePathFilter getFilter(IServer server, IModule[] module) {
                return ResourceModuleResourceUtil.findDefaultModuleFilter((IModule)module[module.length - 1]);
            }
        };
    }

    private LocalZippedModulePublishRunner createZippedRunner(IModule m, IPath p) {
        return new LocalZippedModulePublishRunner(this.getServer(), m, p, this.getModulePathFilterProvider());
    }

    public int transferBuiltModule(IModule[] module, IPath srcFile, IProgressMonitor monitor) throws CoreException {
        String name = this.getDeploymentOutputName(this.getServer(), module[0]);
        IJBoss7DeploymentResult removeResult = this.getService().undeploySync((IAS7ManagementDetails)this.managementDetails, name, true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)10));
        IStatus status1 = removeResult.getStatus();
        IJBoss7DeploymentResult result = this.getService().deploySync((IAS7ManagementDetails)this.managementDetails, name, srcFile.toFile(), true, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)100));
        IStatus status2 = result.getStatus();
        return status1.isOK() && status2.isOK() ? 1 : 0;
    }

    public int removeModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        String name = this.getDeploymentOutputName(this.getServer(), module[0]);
        IJBoss7DeploymentResult removeResult = this.getService().undeploySync((IAS7ManagementDetails)this.managementDetails, name, true, monitor);
        IStatus result = removeResult.getStatus();
        if (result.isOK()) {
            return 1;
        }
        return 3;
    }

    private int getUpdatedPublishState(IServer server) {
        IModule[] modules = server.getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (server.getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            return 1;
        }
        return 2;
    }
}

