/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.RecentlyUpdatedServerLaunches;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllerEnvironment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;

public class DeployableServerBehavior
extends ControllableServerBehavior {
    public ISubsystemController getController(String system) throws CoreException {
        if ("publish".equals(system)) {
            return this.getPublishController();
        }
        return this.getController(system, null);
    }

    protected ILaunchServerController getLaunchController() throws CoreException {
        return (ILaunchServerController)this.getController("launch", null);
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        return (IModuleStateController)this.getController("modules", null);
    }

    protected IServerShutdownController getShutdownController() throws CoreException {
        return (IServerShutdownController)this.getController("shutdown", null);
    }

    protected IPublishController getPublishController() throws CoreException {
        Object o = this.getSharedData("publish");
        if (o != null) {
            return (IPublishController)o;
        }
        return (IPublishController)this.getController("publish", null);
    }

    public ISubsystemController getController(String system, ControllerEnvironment env) throws CoreException {
        ISubsystemController ret = this.getOverrideController(system, env);
        if (ret == null) {
            String profile = ServerProfileModel.getProfile((IServerAttributes)this.getServer());
            ServerProfileModel.ServerProfile sp = ServerProfileModel.getDefault().getProfile(this.getServer().getServerType().getId(), profile);
            if (sp == null) {
                ServerProfileModel.getDefault().logMissingProfile(this.getServer(), profile);
            } else {
                ret = ServerProfileModel.getDefault().getController(this.getServer(), profile, system, env);
            }
        }
        if (ret == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", 0, "Unable to locate system " + system + " for server " + this.getServer().getName(), null));
        }
        return ret;
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
        IPublishController controller = this.getPublishController();
        this.putSharedData("publish", controller);
        controller.publishStart(monitor);
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        IPublishController controller = this.getPublishController();
        try {
            controller.publishFinish(monitor);
        }
        finally {
            this.putSharedData("publish", null);
        }
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        RecentlyUpdatedServerLaunches.getDefault().setRecentServer(this.getServer());
        super.setupLaunchConfiguration(workingCopy, monitor);
    }

    public void setServerStarted() {
        super.setServerStarted();
        IServer s = this.getServer();
        JBossExtendedProperties properties = (JBossExtendedProperties)s.loadAdapter(JBossExtendedProperties.class, null);
        if (properties != null) {
            Job rootJob;
            Job scannerJob = null;
            boolean addScanners = this.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", true);
            if (addScanners) {
                scannerJob = properties.getDeploymentScannerModifier().getUpdateDeploymentScannerJob(s);
            }
            IServerModuleStateVerifier verifier = properties.getModuleStateVerifier();
            UpdateModuleStateJob moduleStateJob = null;
            if (verifier != null) {
                moduleStateJob = new UpdateModuleStateJob(s, verifier, true, 10000);
            }
            if ((rootJob = this.chainJobs(scannerJob, moduleStateJob)) != null) {
                rootJob.schedule();
            }
        }
    }

    private Job chainJobs(final Job job1, final Job job2) {
        if (job1 == null) {
            return job2;
        }
        if (job2 == null) {
            return job1;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job1.removeJobChangeListener((IJobChangeListener)this);
                if (job2 != null && event.getResult() != null && event.getResult().getSeverity() != 4 && event.getResult().getSeverity() != 8) {
                    job2.schedule();
                }
            }
        };
        job1.addJobChangeListener((IJobChangeListener)listener);
        return job1;
    }
}

