/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.injection;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

public class InjectionModule
extends AbstractModule {
    protected void configure() {
    }

    @Singleton
    @Provides
    public EventBus provideWorkspaceEventBus() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor pool = InjectionModule.coreThreadsTimoutExecutor(numberOfCores + 1, 1, "Recommenders-Bus-Thread-", 1L, TimeUnit.MINUTES);
        return new AsyncEventBus("Recommenders asychronous Workspace Event Bus", (Executor)pool);
    }

    private static ThreadPoolExecutor coreThreadsTimoutExecutor(int numberOfThreads, int threadPriority, String threadNamePrefix, long timeout, TimeUnit unit) {
        ThreadFactory factory = new ThreadFactoryBuilder().setPriority(threadPriority).setNameFormat(String.valueOf(threadNamePrefix) + "%d").setDaemon(true).build();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, timeout, unit, new LinkedBlockingQueue<Runnable>(), factory);
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }
}

