/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.internal.core.refactoring.CDIRefactoringProcessor;

public class DeleteAllInjectedConstructorsProcessor
extends CDIRefactoringProcessor {
    private IMethod method;

    public DeleteAllInjectedConstructorsProcessor(IFile file, IMethod method, String label) {
        super(file, label);
        this.method = method;
    }

    private void changeConstructors(IClassBean bean) throws JavaModelException {
        Collection<IBeanMethod> constructors = bean.getBeanConstructors();
        if (constructors.size() > 1) {
            ICompilationUnit original = constructors.iterator().next().getMethod().getCompilationUnit();
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            for (IBeanMethod constructor : constructors) {
                if (constructor.getMethod().isSimilar(this.method)) continue;
                CDIMarkerResolutionUtils.deleteAnnotation((String)"javax.inject.Inject", (ICompilationUnit)compilationUnit, (IJavaElement)constructor.getMethod(), (MultiTextEdit)((MultiTextEdit)this.change.getEdit()));
            }
            compilationUnit.discardWorkingCopy();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.createRootChange();
        if (this.bean != null) {
            this.changeConstructors(this.bean);
        }
        return this.status;
    }
}

