/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.jboss.tools.cdi.core.IBeanMethod;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.internal.core.refactoring.CDIRefactoringProcessor;

public class DeleteAllDisposerAnnotationsProcessor
extends CDIRefactoringProcessor {
    private IMethod method;

    public DeleteAllDisposerAnnotationsProcessor(IFile file, IMethod method, String label) {
        super(file, label);
        this.method = method;
    }

    private void changeDisposers(IClassBean bean) throws JavaModelException {
        if (bean.getDisposers().isEmpty()) {
            return;
        }
        for (IProducer producer : bean.getProducers()) {
            if (!(producer instanceof IProducerMethod)) continue;
            IProducerMethod producerMethod = (IProducerMethod)producer;
            Collection<IBeanMethod> disposerMethods = producer.getCDIProject().resolveDisposers(producerMethod);
            ICompilationUnit original = producerMethod.getMethod().getCompilationUnit();
            ICompilationUnit compilationUnit = original.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            for (IBeanMethod disposerMethod : disposerMethods) {
                if (disposerMethod.getMethod().isSimilar(this.method)) continue;
                CDIMarkerResolutionUtils.deleteAnnotation((String)"javax.enterprise.inject.Disposes", (ICompilationUnit)compilationUnit, (IJavaElement)disposerMethod.getMethod().getParameters()[0], (MultiTextEdit)((MultiTextEdit)this.change.getEdit()));
            }
            compilationUnit.discardWorkingCopy();
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.createRootChange();
        if (this.bean != null) {
            this.changeDisposers(this.bean);
        }
        return this.status;
    }
}

