/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.internal.core.project.facet.ICDIFacetDataModelProperties;

public class CDIFacetInstallDelegate
implements ILogListener,
IDelegate,
ICDIFacetDataModelProperties {
    public static IProjectFacet CDI_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.cdi");
    public static final IProjectFacetVersion CDI_10 = CDI_FACET.getVersion(CDIVersion.CDI_1_0.toString());
    public static final IProjectFacetVersion CDI_11 = CDI_FACET.getVersion(CDIVersion.CDI_1_1.toString());
    public static final IProjectFacetVersion CDI_12 = CDI_FACET.getVersion(CDIVersion.CDI_1_2.toString());
    private boolean errorOccurs = false;

    public void logging(IStatus status, String plugin) {
        if (status.getPlugin().equals("org.jboss.tools.cdi.core")) {
            this.errorOccurs = true;
        }
    }

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IDataModel model = (IDataModel)config;
        boolean generateBeansXml = model.getBooleanProperty("cdi.project.generateBeansXml");
        CDIVersion beansXmlVersion = null;
        if (generateBeansXml) {
            beansXmlVersion = fv.compareTo((Object)CDI_10) == 0 ? CDIVersion.CDI_1_0 : CDIVersion.CDI_1_1;
        }
        CDIUtil.enableCDI(project, beansXmlVersion, monitor);
        if (this.errorOccurs) {
            this.errorOccurs = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)CDICoreMessages.CDI_FACET_INSTALL_ABSTRACT_DELEGATE_ERROR, (String)CDICoreMessages.CDI_FACET_INSTALL_ABSTRACT_DELEGATE_CHECK_ERROR_LOG_VIEW, (IStatus)new Status(4, "org.jboss.tools.cdi.core", CDICoreMessages.CDI_FACET_INSTALL_ABSTRACT_DELEGATE_ERRORS_OCCURED));
                }
            });
        }
    }

    public Object create() throws CoreException {
        return null;
    }
}

